part of search;

class SearchPage extends StatefulWidget {
  const SearchPage({Key? key}) : super(key: key);

  @override
  State<SearchPage> createState() => _SearchPageState();
}

class _SearchPageState extends State<SearchPage> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<SearchController>(
      init: SearchController(),
      builder: (controller) => Scaffold(
        appBar: CustomAppBar(
          automaticallyImplyLeading: false,
          titleSpacing: 0,
          title: Padding(
            padding: EdgeInsets.symmetric(horizontal: AppTheme.margin),
            child: CustomInputSearch(
              controller: controller.searchController,
              readOnly: false,
              hintText: '请输入书籍名称',
              onTap: () {
                // context.pushNamed(Routes.msgs);
              },
              onEditingComplete: () {
                controller.showHistory = false;
                controller.search();
                // FocusScope.of(context).unfocus();
                FocusNode blankNode = FocusNode();
                FocusScope.of(context).requestFocus(blankNode); //指定为空白焦点
              },
            ),
          ),
          actions: [
            GestureDetector(
              onTap: () {
                context.pop();
              },
              child: Container(
                padding: EdgeInsets.only(left: 10.w, top: 10.w, bottom: 10.w),
                child: Text(
                  '取消',
                  style:
                      TextStyle(fontSize: 14.w, height: 1.5, color: Colours.c3),
                ),
              ),
            )
          ],
        ),
        body: buildListView(controller),
      ),
    );
  }

  Widget buildListView(SearchController controller) {
    if (controller.showHistory) {
      // 如果条件为true，显示历史搜索记录
      return BuildHistory(controller: controller);
    } else {
      // 如果条件为false，显示搜索到的书籍
      return ListView.builder(
          // shrinkWrap: true,
          // physics: NeverScrollableScrollPhysics(),
          scrollDirection: Axis.vertical,
          itemCount: controller.books.length,
          itemBuilder: (BuildContext context, int index) {
            CourseModel model = controller.books[index];
            return GestureDetector(
              onTap: () {
                context.pushNamed(Routes.bookDetail,
                    queryParameters: {'book_id': model.bookId.toString()});
              },
              child: LibraryCell(
                model: model,
                onTap: () {
                  controller.love(
                      bookId: model.bookId.toString(),
                      isCollection: model.isCollection!);
                },
              ),
            );
          });
    }
  }

  hideSoftKeyboard(BuildContext context) {
    FocusNode blankNode = FocusNode(); //空白焦点,不赋值给任何输入框的focusNode
    FocusScope.of(context).requestFocus(blankNode); //指定为空白焦点
  }
}
