part of user_nick;

class UserNickController extends GetxController {
  // 用户信息模型
  final UserInfoModel userInfo;

  UserNickController(this.userInfo);

  /// 修改用用户信息
  void changeInfo(String nick) async {
    final result = await MineAPI.changeInfo(name: nick);
    if (result) {
      Toast.show('修改成功');

      userInfo.name = nick;

      Map<String, dynamic> map = jsonDecode(StorageService.to.getString(kLocalUserInfo));
      if (map.keys.contains('name')) {
        map['name'] = nick;
        await StorageService.to.setString(kLocalUserInfo, jsonEncode(map));
      }
      update();
      Get.put(MineController()).getInfo();
    }
  }
}
