part of user_notes;

class UserNoteController extends GetxController {
  final EasyRefreshController refreshController = EasyRefreshController(
    controlFinishLoad: true,
    controlFinishRefresh: true,
  );

  // 笔记数据
  List<CourseModel> notes = [];
  // 每页数量
  final int _limit = 10;
  // 当前页码
  int _page = 1;
  // 是否有更多
  bool _noMore = false;

  @override
  void onReady() {
    onRefresh();
    super.onReady();
  }

  @override
  void onClose() {
    refreshController.dispose();
    super.onClose();
  }

  /// 获取笔记列表
  Future<void> _getNotes([bool isRefresh = false]) async {
    if (isRefresh) _page = 1;
    // 网路请求
    final result = await MineAPI.note(page: _page, limit: _limit);
    // 如果是刷新 清理数据
    if (isRefresh) notes.clear();
    // notes.addAll(_test());
    notes.addAll(result);
    _page++;
    _noMore = result.length < _limit;
    update();
  }

  /// 刷新数据
  void onRefresh() async {
    try {
      await _getNotes(true);
      refreshController.finishRefresh(IndicatorResult.success);
      refreshController.resetFooter();
    } catch (error) {
      refreshController.finishRefresh(IndicatorResult.fail);
    }
  }

  /// 加载数据
  void onLoading() async {
    if (_noMore) {
      refreshController.finishLoad(IndicatorResult.noMore);
      return;
    }
    try {
      await _getNotes();
      refreshController.finishLoad();
    } catch (error) {
      refreshController.finishLoad(IndicatorResult.fail);
    }
  }

  /// 测试数据
  List<CourseModel> _test() {
    return [
      CourseModel(),
      CourseModel(),
      CourseModel(),
    ];
  }
}
