part of models;

/// 已完成订单
class OrderCompletedModel {
  OrderCompletedModel(
      {required this.value, required this.name, this.link, this.other});

  String value;
  String name;
  String? link;
  String? other;
}

/// 已完成订单详细信息模型
class OrderCompletedInfoModel {
  OrderCompletedInfoModel({
    this.id,
    this.price,
    this.totalPay,
    this.favorable,
    this.orderId,
    this.payWay,
    this.payTime,
    this.orderTime,
  });

  OrderCompletedInfoModel.fromJson(dynamic json) {
    id = json['id'];
    price = json['price'];
    totalPay = json['totalPay'];
    favorable = json['favorable'];
    orderId = json['orderId'];
    payWay = json['payWay'];
    payTime = json['payTime'];
    orderTime = json['orderTime'];
  }

  num? id;
  String? price; // 价格
  String? totalPay;
  String? favorable; // 优惠
  String? orderId; // 订单编号
  String? payWay; // 支付方式
  String? payTime; // 支付时间
  String? orderTime; // 下单时间

  OrderCompletedInfoModel copyWith({
    num? id,
    String? price,
    String? totalPay,
    String? favorable,
    String? orderId,
    String? payWay,
    String? payTime,
    String? orderTime,
  }) =>
      OrderCompletedInfoModel(
        id: id ?? this.id,
        price: price ?? this.price,
        totalPay: totalPay ?? this.totalPay,
        favorable: favorable ?? this.favorable,
        orderId: orderId ?? this.orderId,
        payWay: payWay ?? this.payWay,
        payTime: payTime ?? this.payTime,
        orderTime: orderTime ?? this.orderTime,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['price'] = price;
    map['totalPay'] = totalPay;
    map['favorable'] = favorable;
    map['orderId'] = orderId;
    map['payWay'] = payWay;
    map['payTime'] = payTime;
    map['orderTime'] = orderTime;
    return map;
  }
}

/// 订单列表模型
class OrderListModel {
  OrderListModel({
    this.id,
    this.ordersnum,
    this.totalPrice,
    this.finalTotalPrice,
    this.num_,
    this.status,
    this.payType,
    this.types,
    this.createTime,
    this.cartList,
  });

  OrderListModel.fromJson(dynamic json) {
    id = json['id'];
    ordersnum = json['ordersnum'];
    totalPrice = json['total_price'];
    finalTotalPrice = json['final_total_price'];
    num_ = json['num'];
    status = json['status'];
    payType = json['pay_type'];
    types = json['types'];
    createTime = json['create_time'];
    if (json['cart_list'] != null) {
      cartList = [];
      json['cart_list'].forEach((v) {
        cartList?.add(CartListModel.fromJson(v));
      });
    }
  }

  num? id;  //订单id
  String? ordersnum; //订单编号
  String? totalPrice; // 原价总价
  String? finalTotalPrice; //最终总价
  num? num_; //商品数量
  num? status; //订单状态 1：待支付，2取消支付，3：已支付 4:已退款
  num? payType; //支付方式 1：微信 2：支付宝,3：紫荆币
  num? types; //1是书籍订单  2是充值订单
  String? createTime; //创建时间
  List<CartListModel>? cartList = [];

  OrderListModel copyWith({
    num? id,
    String? ordersnum,
    String? totalPrice,
    String? finalTotalPrice,
    num? num,
    num? status,
    num? payType,
    num? types,
    String? createTime,
    List<CartListModel>? cartList,
  }) =>
      OrderListModel(
        id: id ?? this.id,
        ordersnum: ordersnum ?? this.ordersnum,
        totalPrice: totalPrice ?? this.totalPrice,
        finalTotalPrice: finalTotalPrice ?? this.finalTotalPrice,
        status: status ?? this.status,
        num_: num_ ?? this.num_,
        payType: payType ?? this.payType,
        types: types ?? this.types,
        createTime: createTime ?? this.createTime,
        cartList: cartList ?? this.cartList,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['ordersnum'] = ordersnum;
    map['total_price'] = totalPrice;
    map['final_total_price'] = finalTotalPrice;
    map['num'] = num_;
    map['status'] = status;
    map['pay_type'] = payType;
    map['types'] = types;
    map['create_time'] = createTime;
    if (cartList != null) {
      map['cart_list'] = cartList?.map((v) => v.toJson()).toList();
    }
    return map;
  }

  @override
  String toString() {
    return 'OrderListModel{id: $id, ordersnum: $ordersnum, totalPrice: $totalPrice, finalTotalPrice: $finalTotalPrice, num_: $num_, status: $status, payType: $payType, types: $types, createTime: $createTime, cartList: $cartList}';
  }
}

/// 书籍列表
class CartListModel {
  CartListModel({
    this.recordId,
    this.orderId,
    this.price,
    this.num_,
    this.bookId,
    this.isRating,
    this.name,
    this.img,
    this.introduction,
    this.rating,
    this.comments,
    this.commentId,
  });

  CartListModel.fromJson(dynamic json) {
    recordId = json['record_id'];
    orderId = json['order_id'];
    price = json['price'];
    num_ = json['num'];
    bookId = json['book_id'];
    isRating = json['is_rating'];
    name = json['name'];
    img = json['img'];
    introduction = json['introduction'];
    rating = json['rating'];
    comments = json['comments'];
    commentId = json['comment_id'];
  }

  num? recordId; //书籍记录id
  num? orderId; //对应订单id
  String? price; // 书籍价格
  num? num_; // 书籍价格
  num? bookId; //书籍id，为0则是充值的没有书籍
  num? isRating; //书籍id，为0则是充值的没有书籍
  String? name; // 书籍名
  String? img; // 图片
  String? introduction; // 简介
  num? rating; // 评价星级
  String? comments; // 评价内容
  String? commentId; // 评价id

  CartListModel copyWith({
    num? recordId, //书籍记录id
    num? orderId, //对应订单id
    String? price, // 书籍价格
    num? num_, // 书籍价格
    num? bookId, //书籍id，为0则是充值的没有书籍
    num? isRating, //书籍id，为0则是充值的没有书籍
    String? name, // 书籍名
    String? img, // 图片
    String? introduction, // 简介
    num? rating, // 评价星级
    String? comments, // 评价内容
    String? commentId, // 评价id
  }) =>
      CartListModel(
        recordId: recordId ?? this.recordId,
        orderId: orderId ?? this.orderId,
        price: price ?? this.price,
        num_: num_ ?? this.num_,
        bookId: bookId ?? this.bookId,
        isRating: isRating ?? this.isRating,
        name: name ?? this.name,
        img: img ?? this.img,
        introduction: introduction ?? this.introduction,
        rating: rating ?? this.rating,
        comments: comments ?? this.comments,
        commentId: commentId ?? this.commentId,
      );

  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['record_id'] = recordId;
    map['order_id'] = orderId;
    map['num'] = num_;
    map['price'] = price;
    map['book_id'] = bookId;
    map['is_rating'] = isRating;
    map['name'] = name;
    map['img'] = img;
    map['introduction'] = introduction;
    map['rating'] = rating;
    map['comments'] = comments;
    map['comment_id'] = commentId;
    return map;
  }
}


/// 订单详情
class OrderInfoModel {
  OrderInfoModel({
    this.id,
    this.ordersnum,
    this.goodsId,
    this.goodsName,
    this.totalPrice,
    this.finalTotalPrice,
    this.nums,
    this.status,
    this.createTime,
    this.couponPrice,
    this.integralPrice,
    this.payType,
    this.payTime,
    this.refundTime,
    this.refundReason,
    this.types,
    this.bean,
    this.bookList,});

  OrderInfoModel.fromJson(dynamic json) {
    id = json['id'];
    ordersnum = json['ordersnum'];
    goodsId = json['goods_id'];
    goodsName = json['goods_name'];
    totalPrice = json['total_price'];
    finalTotalPrice = json['final_total_price'];
    nums = json['num'];
    status = json['status'];
    createTime = json['create_time'];
    couponPrice = json['coupon_price'];
    integralPrice = json['integral_price'];
    payType = json['pay_type'];
    payTime = json['pay_time'];
    refundTime = json['refund_time'];
    refundReason = json['refund_reason'];
    types = json['types'];
    bean = json['bean'];
    if (json['list'] != null) {
      bookList = [];
      json['list'].forEach((v) {
        bookList?.add(BookListModel.fromJson(v));
      });
    }
  }
  num? id;
  String? ordersnum;
  String? goodsId; //充值的凭证
  String? goodsName;//充值名称
  String? totalPrice;
  String? finalTotalPrice;
  num? nums;
  num? status;
  String? createTime;
  String? couponPrice;
  String? integralPrice;
  num? payType;
  String? payTime;
  String? refundTime;
  String? refundReason;
  num? types;
  num? bean;
  List<BookListModel>? bookList;
  OrderInfoModel copyWith({  num? id,
    String? ordersnum,
    String? goodsId,
    String? goodsName,
    String? totalPrice,
    String? finalTotalPrice,
    num? nums,
    num? status,
    String? createTime,
    String? couponPrice,
    String? integralPrice,
    num? payType,
    String? payTime,
    String? refundTime,
    String? refundReason,
    num? types,
    num? bean,
    List<BookListModel>? bookList,
  }) => OrderInfoModel(  id: id ?? this.id,
    ordersnum: ordersnum ?? this.ordersnum,
    goodsId: ordersnum ?? this.goodsId,
    goodsName: ordersnum ?? this.goodsName,
    totalPrice: totalPrice ?? this.totalPrice,
    finalTotalPrice: finalTotalPrice ?? this.finalTotalPrice,
    nums: nums ?? this.nums,
    status: status ?? this.status,
    createTime: createTime ?? this.createTime,
    couponPrice: couponPrice ?? this.couponPrice,
    integralPrice: integralPrice ?? this.integralPrice,
    payType: payType ?? this.payType,
    payTime: payTime ?? this.payTime,
    refundTime: refundTime ?? this.refundTime,
    refundReason: refundReason ?? this.refundReason,
    types: types ?? this.types,
    bean: bean ?? this.bean,
    bookList: bookList ?? this.bookList,
  );
  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['id'] = id;
    map['ordersnum'] = ordersnum;
    map['goods_id'] = goodsId;
    map['goods_name'] = goodsName;
    map['total_price'] = totalPrice;
    map['final_total_price'] = finalTotalPrice;
    map['num'] = nums;
    map['status'] = status;
    map['create_time'] = createTime;
    map['coupon_price'] = couponPrice;
    map['integral_price'] = integralPrice;
    map['pay_type'] = payType;
    map['pay_time'] = payTime;
    map['refund_time'] = refundTime;
    map['refund_reason'] = refundReason;
    map['types'] = types;
    map['bean'] = bean;
    if (bookList != null) {
      map['list'] = bookList?.map((v) => v.toJson()).toList();
    }
    return map;
  }

}

/// book_id : 110
/// name : "ASASDASD"
/// img : "img"
/// introduction : "introduction"
/// price : "45.00"
/// rating : 0
/// comments : 0
/// create_time : 0

class BookListModel {
  BookListModel({
    this.bookId,
    this.recordId,
    this.name,
    this.img,
    this.introduction,
    this.price,
    this.rating,
    this.comments,
    this.createTime,});

  BookListModel.fromJson(dynamic json) {
    bookId = json['book_id'];
    recordId = json['record_id'];
    name = json['name'];
    img = json['img'];
    introduction = json['introduction'];
    price = json['price'];
    rating = json['rating'];
    comments = json['comments'];
    createTime = json['create_time'];
  }
  num? bookId;
  num? recordId;
  String? name;
  String? img;
  String? introduction;
  String? price;
  num? rating;
  num? comments;
  num? createTime;
  BookListModel copyWith({  num? bookId,
    num? recordId,
    String? name,
    String? img,
    String? introduction,
    String? price,
    num? rating,
    num? comments,
    num? createTime,
  }) => BookListModel(  bookId: bookId ?? this.bookId,
    recordId: recordId ?? this.recordId,
    name: name ?? this.name,
    img: img ?? this.img,
    introduction: introduction ?? this.introduction,
    price: price ?? this.price,
    rating: rating ?? this.rating,
    comments: comments ?? this.comments,
    createTime: createTime ?? this.createTime,
  );
  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['book_id'] = bookId;
    map['record_id'] = recordId;
    map['name'] = name;
    map['img'] = img;
    map['introduction'] = introduction;
    map['price'] = price;
    map['rating'] = rating;
    map['comments'] = comments;
    map['create_time'] = createTime;
    return map;
  }

}



/// record_id : 11
/// rating : 1
/// comments : "内容"
/// 订单评价
class OrderEvaluate {
  OrderEvaluate({
    this.recordId,
    this.rating,
    this.comments,});

  OrderEvaluate.fromJson(dynamic json) {
    recordId = json['record_id'];
    rating = json['rating'];
    comments = json['comments'];
  }
  num? recordId;
  num? rating;
  String? comments;
  OrderEvaluate copyWith({  num? recordId,
    num? rating,
    String? comments,
  }) => OrderEvaluate(  recordId: recordId ?? this.recordId,
    rating: rating ?? this.rating,
    comments: comments ?? this.comments,
  );
  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['record_id'] = recordId;
    map['rating'] = rating;
    map['comments'] = comments;
    return map;
  }

}
