part of mine;

class BuildAccount extends StatelessWidget {
  final List<ReadModel> items ;
  final void Function(ReadModel model)? onTap;
  const BuildAccount({
    super.key,
    this.onTap,
    this.items = const []
  });

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: EdgeInsets.symmetric(horizontal: AppTheme.margin),
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(8.w),
        color:Colors.white,
        boxShadow: [
          BoxShadow(
            color: const Color(0xFFC7C7C7).withOpacity(0.5),
            offset: Offset(3.w, 0),
            blurRadius: 10.w,
            spreadRadius: 0.w,
          ),
        ],
      ),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Container(
            padding: EdgeInsets.only(left: 17.w,top: 14.w,bottom: 14.w,right: 17.w),
            child: Text('我的账户',style: TextStyle(color: Colours.c3,fontSize: 14.w,height: 1.6,fontWeight: Fonts.boldSemi),),
          ),
          Container(
            padding: EdgeInsets.only(bottom: 13.w,top: 5.w),
            child: Row(
              mainAxisAlignment: MainAxisAlignment.spaceEvenly,
              children: items.map((model){
                return Expanded(
                  child: GestureDetector(
                    onTap: (){
                      if (onTap !=null) onTap!(model);
                      // if (model.link != null){
                      //   if (model.link != Routes.love){
                      //     context.pushNamed(model.link!);
                      //   }
                      //   else{
                      //     if (onTap !=null) onTap!(model);
                      //   }
                      // }
                    },
                    child: Container(
                      color: Colors.white,
                      child: Column(
                        children: [
                          SizedBox(
                            width: 25.w,
                            height: 25.w,
                            // color: Colors.green,
                            child: Image.asset(model.icon!),
                          ),
                          Gaps.vGaps5,
                          Text(model.name,style: TextStyle(fontSize:12.w,height: 1.6.w,color: Colours.c9),),
                          items.indexOf(model) == 0?Row(
                            mainAxisAlignment: MainAxisAlignment.center,
                            children: [
                              Text(model.value.toString(),style: TextStyle(fontSize: 16.w,height: 1.6,fontWeight: Fonts.medium,color: AppTheme.primary,),),
                              Text('张',style: TextStyle(fontSize: 12.w,height:1.6.w,color: Colours.c3),)
                            ],
                          ):Text(model.value.toString(),style: TextStyle(fontSize: 16.w,height:1.6.w,color: Colours.c3),)
                        ],
                      ),
                    ),
                  ),
                );
              } ).toList(),
            ),
          )
        ],
      ),
    );
  }
}
