part of user_order_awaiting;

class UserOrderAwaitingPage extends StatefulWidget {
  final String orderNum; // 订单编号
  const UserOrderAwaitingPage({Key? key , required this.orderNum}) : super(key: key);

  @override
  State<UserOrderAwaitingPage> createState() => _UserOrderAwaitingState();
}

class _UserOrderAwaitingState extends State<UserOrderAwaitingPage> {
  @override
  void initState() {
    Get.put(UserOrderAwaitingController(widget.orderNum));
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: () async {
        context.pop(true);
        return false;
      },
      child: GetBuilder<UserOrderAwaitingController>(
          init: UserOrderAwaitingController(widget.orderNum),
          builder: (controller) => Scaffold(
                appBar: CustomAppBar(
                  title: const Text('等待付款'),
                  actions: [],
                ),
                body: Column(
                  children: [
                    Container(
                      margin: EdgeInsets.symmetric(
                          horizontal: AppTheme.margin,
                          vertical: AppTheme.margin),
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(8.w),
                        color: Colors.white,
                        boxShadow: [
                          BoxShadow(
                            color: Colours.cC7.withOpacity(0.5),
                            offset: Offset(3.w, 0),
                            blurRadius: 10.w,
                            spreadRadius: 0.w,
                          ),
                        ],
                      ),
                      child: ClipRRect(
                        borderRadius: BorderRadius.circular(8.w),
                        child: Column(
                          mainAxisAlignment: MainAxisAlignment.start,
                          mainAxisSize: MainAxisSize.min,
                          children: [
                            Padding(
                              padding: EdgeInsets.only(
                                  left: 12.0.w, top: 12.0.w, bottom: 12.0.w),
                              child: Row(
                                mainAxisAlignment: MainAxisAlignment.start,
                                crossAxisAlignment: CrossAxisAlignment.start,
                                children: [
                                  Image.network(
                                    controller.model?.bookList?[0].img??'',
                                    fit: BoxFit.cover, // 设置适应方式为充满
                                    width: 72.0.w,
                                    height: 86.0.w,
                                  ),
                                  Expanded(
                                    child: Padding(
                                      padding: EdgeInsets.only(
                                          left: 12.0.w,
                                          top: 5.5.w,
                                          right: 23.5.w),
                                      child: Column(
                                        mainAxisAlignment:
                                            MainAxisAlignment.spaceBetween,
                                        crossAxisAlignment:
                                            CrossAxisAlignment.end, // 下面的Text靠左
                                        children: [
                                          Text(
                                            controller.model.bookList?[0].introduction??'',
                                            style: TextStyle(
                                              color: Colours.c3,
                                              fontWeight: Fonts.bold,
                                              fontSize: 13.w,
                                            ),
                                            maxLines: 2,
                                            overflow: TextOverflow
                                                .ellipsis, // 超过部分显示省略号
                                          ),
                                          SizedBox(height: 25.5.w),
                                          Text(
                                            "需付款 ¥${controller.model.finalTotalPrice}",
                                            style: TextStyle(
                                              color: Colours.cAB1941,
                                              fontWeight: Fonts.bold,
                                              fontSize: 14.w,
                                            ),
                                          ),
                                        ],
                                      ),
                                    ),
                                  ),
                                ],
                              ),
                            ),
                            Container(
                              color: Colours.cLine,
                              margin: EdgeInsets.only(
                                  left: 10.w, right: 10.w, bottom: 12.w),
                              height: 1.w,
                            ),
                            Container(
                              padding: EdgeInsets.only(
                                  left: 11.5.w, bottom: 8.w, right: 23.5.w),
                              child: Column(
                                mainAxisAlignment:
                                    MainAxisAlignment.spaceEvenly,
                                children:
                                    controller.orderAwaitings.map((model) {
                                  return Padding(
                                    padding: EdgeInsets.only(top: 12.w),
                                    child: Row(
                                      mainAxisAlignment:
                                          MainAxisAlignment.spaceBetween,
                                      children: [
                                        Text(
                                          model.name,
                                          style: TextStyle(
                                              fontSize: 13.w,
                                              height: 1.6.w,
                                              color: Colours.c9),
                                        ),
                                        Text(
                                          model.value.toString(),
                                          style: TextStyle(
                                              fontSize: 13.w,
                                              height: 1.6.w,
                                              color: Colours.c3),
                                        ),
                                      ],
                                    ),
                                  );
                                }).toList(),
                              ),
                            ),
                            SizedBox(
                              height: 13.5.w,
                            ),
                          ],
                        ),
                      ),
                    ),
                    SizedBox(
                      height: 39.w,
                    ),
                    Container(
                      margin: EdgeInsets.symmetric(horizontal: 15.w),
                      height: 40.w,
                      decoration: BoxDecoration(
                          color: AppTheme.primary,
                          borderRadius: BorderRadius.circular(180.w),
                          border:
                              Border.all(color: Colours.cC31F4C, width: 0.5.w)),
                      child: Center(
                        child: GestureDetector(
                            onTap: () {
                              // print("保存昵称");
                              context.pushNamed(Routes.orderEvaluate);
                            },
                            child: Text(
                              '立即支付 ¥${controller.model.finalTotalPrice}',
                              style: TextStyle(
                                  fontWeight: Fonts.medium,
                                  fontSize: 14.w,
                                  color: Colours.cFF),
                            )),
                      ),
                    ),
                    SizedBox(
                      height: 11.5.w,
                    ),
                    GestureDetector(
                      onTap: () {
                        CustomDialog.show(context: context, builder:(context) =>
                            Text('确定取消订单吗',style: TextStyle(fontSize: 15.w,fontWeight: Fonts.medium,color: Colours.c3),),
                            cancel: Text('取消',style: TextStyle(fontSize: 12.w,fontWeight: Fonts.medium,color: Colours.c6),),
                        confirm: Text('确定',style: TextStyle(fontSize: 12.w,fontWeight: Fonts.medium,color: Colours.cFF),),
                        onCancel: () {
                          Navigator.of(context).pop();
                        },
                        onConfirm: () {
                          controller.cancelPay();
                          Navigator.of(context).pop();
                          Navigator.pop(context);
                        },);
                        // Navigator.pop(context);
                      },
                      child: Text(
                        '取消订单',
                        style: TextStyle(
                            fontWeight: Fonts.medium,
                            fontSize: 15.w,
                            color: Colours.c9),
                      ),
                    ),
                  ],
                ),
              )),
    );
  }
}
