part of models;
/// 1、图书分类模型
///
class CategoryModel {
  CategoryModel({
    this.categoryId,
    this.name,
  });

  CategoryModel.fromJson(dynamic json) {
    categoryId = json['category_id'];
    name = json['name'];
  }
  num? categoryId;
  String? name;
  CategoryModel copyWith({  num? categoryId,
    String? name,
  }) => CategoryModel(  categoryId: categoryId ?? this.categoryId,
    name: name ?? this.name,
  );
  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['category_id'] = categoryId;
    map['name'] = name;
    return map;
  }
}


/// 2、图书标签模型
///
class LabelModel {
  LabelModel({
    this.labelId,
    this.name,
  });

  LabelModel.fromJson(dynamic json) {
    labelId = json['label_id'];
    name = json['name'];
  }
  num? labelId;
  String? name;
  LabelModel copyWith({  num? labelId,
    String? name,
  }) => LabelModel(  labelId: labelId ?? this.labelId,
    name: name ?? this.name,
  );
  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['label_id'] = labelId;
    map['name'] = name;
    return map;
  }

}

/// 3、书籍评价模型
///
/// book_comment_id : 4
/// comments : "bbbbbbb"
/// rating : 4.5
/// create_time : "2021-09-01 18:38:27"
/// members_id : 385
/// users : "王多余5"
/// users_img : ""

class ScoreModel {
  ScoreModel({
    this.bookCommentId,
    this.comments,
    this.rating,
    this.createTime,
    this.membersId,
    this.users,
    this.usersImg,});

  ScoreModel.fromJson(dynamic json) {
    bookCommentId = json['book_comment_id'];
    comments = json['comments'];
    rating = json['rating'];
    createTime = json['create_time'];
    membersId = json['members_id'];
    users = json['users'];
    usersImg = json['users_img'];
  }
  num? bookCommentId;
  String? comments;
  num? rating;
  String? createTime;
  num? membersId;
  String? users;
  String? usersImg;

  ScoreModel copyWith({  num? bookCommentId,
    String? comments,
    num? rating,
    String? createTime,
    num? membersId,
    String? users,
    String? usersImg,
  }) => ScoreModel(  bookCommentId: bookCommentId ?? this.bookCommentId,
    comments: comments ?? this.comments,
    rating: rating ?? this.rating,
    createTime: createTime ?? this.createTime,
    membersId: membersId ?? this.membersId,
    users: users ?? this.users,
    usersImg: usersImg ?? this.usersImg,
  );
  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['book_comment_id'] = bookCommentId;
    map['comments'] = comments;
    map['rating'] = rating;
    map['create_time'] = createTime;
    map['members_id'] = membersId;
    map['users'] = users;
    map['users_img'] = usersImg;
    return map;
  }

}


