part of book_info;

class BookInfoPage extends StatefulWidget {
  const BookInfoPage({Key? key}) : super(key: key);

  @override
  State<BookInfoPage> createState() => _BookInfoPageState();
}

class _BookInfoPageState extends State<BookInfoPage> {
  @override
  Widget build(BuildContext context) {
    return Container(
      margin: const EdgeInsets.symmetric(horizontal: 15,vertical: 18),
      child: Column(
        children: [
          // 评分容器
          Column(
            children: [
              Container(
                color: Colors.red,
                child: Row(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: [
                    const Text('评分及书评',style: TextStyle(fontSize: 14,color: Colours.c3,height: 1.6,fontWeight: Fonts.medium),),
                    Container(
                     child: Row(
                         children: [
                           GestureDetector(
                             child: const Text('查看全部',style: TextStyle(fontSize: 11,color: Colours.c9),),
                             onTap: (){
                                 context.pushNamed(Routes.bookScore,queryParameters: {'book_id':'110'});
                             },
                           ),
                           Gaps.hGaps5,
                           Container(
                             width: 5,
                             height: 8,
                             // color: Colors.cyan,
                             child: Image.asset(
                               'assets/images/right_arrow.png',
                             ),
                           )
                         ]
                     ),
                    )
                  ],
                ),
              ),
              Container(
                margin: EdgeInsets.symmetric(vertical: 10),
                child: Row(
                  children: [
                    const Column(
                      mainAxisAlignment: MainAxisAlignment.center,
                      // crossAxisAlignment: CrossAxisAlignment.center,
                      children: [
                        Text('4.8',style: TextStyle(fontSize: 35,height: 1.5,fontWeight: Fonts.boldSemi,color: AppTheme.primary),),
                        StarScore(
                          score: 4.5,
                          star: Star(
                              fillColor: AppTheme.primary,
                              size: 12,
                              emptyColor: Color(0xFFEBEBEB)),
                        ),
                      ],
                    ),
                    Expanded(
                      child: Container(
                        height: 90,
                        color: Colors.green,
                        child: Column(
                          mainAxisAlignment: MainAxisAlignment.center,
                          crossAxisAlignment: CrossAxisAlignment.end,
                          children: [
                            _buildProgrss(5, 0.2),
                            _buildProgrss(4, 0.5),
                            _buildProgrss(3, 0.8),
                            _buildProgrss(2, 0.2),
                            _buildProgrss(1, 0.1),
                          ],
                        ),
                      ),
                    )
                  ],
                ),
              )
            ],
          ),
          Container(height: 1,width: double.infinity,color: Colours.cF2,),
          Gaps.vGaps15,
          // 书籍信息
          Container(
            color: Colors.red,
            child: Column(
              mainAxisAlignment: MainAxisAlignment.end,
              crossAxisAlignment: CrossAxisAlignment.start,
              children: ['书名','作者','分类','出品方','出版社','上架时间'].map((item){
                return Row(
                  // mainAxisAlignment: MainAxisAlignment.end,
                  children: [
                    Container(
                      color: Colors.cyan,
                      alignment: Alignment.centerRight,
                      child: Text(item,style: TextStyle(fontSize: 11,height: 2.1,color: Colours.c3),),
                    ),
                    Gaps.hGaps20,
                    Container(
                      alignment: Alignment.centerLeft,
                      child: Text(item,style: TextStyle(fontSize: 11,height: 2.1,color: Colours.c9),textAlign: TextAlign.end,),
                    ),
                  ],
                );
              }).toList(),
            ),
          )
        ],
      ),
    );
  }

  Widget _buildProgrss(double num, double value) {
    return Row(
      mainAxisAlignment: MainAxisAlignment.end,
      children: [
        StarScore(
          score: num,
          star: Star(
              fillColor: Colours.cE2,
              size: 12,
              emptyColor: Colours.cE2,
          ),
        ),
        ClipRRect(
          borderRadius: BorderRadius.circular(2.5),
          child: SizedBox(
            width: 100,
            height: 5,
            child: LinearProgressIndicator(
              value: value, // 设置进度值（0.0 到 1.0）
              color: AppTheme.primary, // 设置进度条颜色
              backgroundColor: Colours.cE2, // 设置背景颜色
            ),
          ),
        ),
      ]
    );
  }
}
