part of library;

class LibraryCell extends StatelessWidget {
  final CourseModel model;
  final void Function() onTap;
  const LibraryCell({
    Key? key,
    required this.model,
    required this.onTap
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
      padding: const EdgeInsets.only(top: 10),
      height: 150,
      // color: Colors.red,
      child: Stack(
        children: [
          Container(
            padding: const EdgeInsets.only(left: 10,top: 10,bottom: 20),
            margin: const EdgeInsets.only(top:15,left: 10,right: 10),
            decoration: BoxDecoration(
              color: Colors.white,
              borderRadius: BorderRadius.circular(8),
              boxShadow: [
                BoxShadow(
                  color: Colours.cC7.withOpacity(0.5), // 阴影颜色
                  spreadRadius: 2, // 阴影扩散半径
                  blurRadius: 5, // 阴影模糊半径
                  offset: const Offset(0, 2), // 阴影偏移
                ),
              ],

            ),
            child: Row(
              children: [
                /// 左侧
                Container(
                  width: 100,
                  height: 120,
                  color: Colors.red,
                ),
                /// 右侧
                Expanded(
                  child: Container(
                    margin: const EdgeInsets.only(left: 10,right: 10),
                    // color: Colors.red,
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      mainAxisSize: MainAxisSize.max,
                      children: [
                        // SizedBox(height: 10,),
                        Text(model.bookName??'',overflow: TextOverflow.ellipsis,maxLines: 2,style: const TextStyle(fontSize: 14,fontWeight: Fonts.medium,height: 1.5,color: Colours.c3),),
                        // const SizedBox(height: 4,),
                        Row(
                          mainAxisAlignment: MainAxisAlignment.spaceBetween,
                          children: [
                            Text(model.authors??'',style: TextStyle(fontSize: 11,color: Colours.c9,height: 1.5),),
                            Row(
                              children: [
                                Text('${model.readNum.toString()}人读过',style:TextStyle(fontSize: 11,height: 1.5,color: Colours.cC7)),
                                Gaps.hGaps5,
                                GestureDetector(
                                  onTap: onTap,
                                  child: SizedBox(
                                    width: 20,
                                    height: 20,
                                    // color: Colors.yellow,
                                    child: Image.asset(
                                      model.isCollection == 0? 'assets/images/unlove.png':'assets/images/love.png',
                                    ),
                                  ),
                                )
                              ],
                            )
                          ],
                        )
                      ],
                    ),
                  ),
                )
              ],
            ),
          ),
          Positioned(
            left: 20,
            top: 0,
            bottom: 18,
            child: Container(
              decoration: BoxDecoration(
                borderRadius: BorderRadius.circular(3),
                color: Colors.cyan,
              ),
              width: 100,
              child: CustomImage.network(url: model.img??''),
            ),
          ),
        ],
      )
    );
  }
}
