part of library;

class LibraryContentPage extends StatefulWidget {
  final LibraryController controller;
  // final CategoryModel categoryModel;
  const LibraryContentPage({
    Key? key,
    required this.controller,
    // required this.categoryModel
  }) : super(key: key);

  @override
  State<LibraryContentPage> createState() => _LibraryContentPageState();
}

class _LibraryContentPageState extends State<LibraryContentPage> {
  @override
  Widget build(BuildContext context) {
    return Column(
      children: [
        Container(
          height: 43,
          // color: Colors.green,
          child: ListView.builder(
            scrollDirection:Axis.horizontal ,
            itemBuilder: (BuildContext context, int index){
              return GestureDetector(
                child: BuildLabelWidget(model: widget.controller.labels[index],),
                onTap: (){

                },
              );
            },
            itemCount: widget.controller.labels.length,
          ),
        ),
        Expanded(
          child: CustomPullScrollView(
            controller: widget.controller.refreshController,
            onRefresh: widget.controller.onRefresh,
            onLoading: widget.controller.onLoading,
            child: NestedScrollView(
              headerSliverBuilder: (BuildContext context ,bool innerBoxIsScrolled){
                return [
                  SliverList(
                      delegate: SliverChildListDelegate([
                        Container(
                          color: Colors.transparent,
                          padding: const EdgeInsets.symmetric(horizontal: 10),
                          child: BuildBanner(items: widget.controller.ads,),
                        ),
                      ])
                  )
                ];
              },
              body: ListView.builder(
                itemCount: widget.controller.books.length,
                itemBuilder: (BuildContext context, int index) {
                  CourseModel model = widget.controller.books[index];
                  return LibraryCell(model: model,onTap: (){
                    widget.controller.love(bookId: model.bookId.toString(), isCollection: model.isCollection!);
                  },);
                },
              ),
            ),
          ),
        ),
      ],
    );
  }
}
