part of user_msg;

class MsgPage extends StatelessWidget {
  const MsgPage({Key? key}) : super(key: key);



  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: () async {
        context.pop(true);
        return false;
      },
      child: GetBuilder<MsgController>(
        init: MsgController(),
        builder:(controller) => Scaffold(
          appBar: AppBar(
            title: const Text('消息中心'),
            centerTitle: true,
          ),
          body: Container(
            color: Colours.cF9,
            child: CustomPullScrollView(
              controller: controller.refreshController,
              onRefresh: controller.onRefresh,
              onLoading: controller.onLoading,
              child: ListView.builder(
                  itemBuilder: (BuildContext context, int index){
                    MsgModel model = controller.msgs[index];
                    return GestureDetector(
                      child: BuildItem(model:model,),
                      onTap: () async{
                          controller.read(model.id.toString());

                          if(model.type == 1){
                            // 1订单支付快要超时（跳转订单详情）
                            final result = await  context.pushNamed(Routes.orderAwaiting,
                                queryParameters: {'orderNum': model.urlId?.orderNum.toString()});
                            if (result == true){
                              controller.onRefresh();
                            }
                            ///TODO:
                          }else if (model.type == 2){
                            // 2  购买完成三天未评价（跳转订单列表--已完成）
                            final result = await context.pushNamed(Routes.order);
                            if (result == true){
                              controller.onRefresh();
                            }
                            ///TODO:
                          }else if (model.type == 3){
                            // 3  讨论有人回复的时候 （跳转对应书籍的讨论页面）
                            final result = await context.pushNamed(Routes.bookDetail,queryParameters: {'book_id':model.urlId?.bookId.toString()});
                            if (result == true){
                              controller.onRefresh();
                            }
                          }
                          else if (model.type == 4){
                            // 4 订单完成后有新的积分增加（跳转用户积分记录页）
                            final result = await context.pushNamed(Routes.point);
                            if (result == true){
                              controller.onRefresh();
                            }

                          }else if (model.type == 5){
                            // 5后台直接发放给指定用户优惠券（跳转到用户优惠券页）
                            final result = await context.pushNamed(Routes.coupon);
                            if (result == true){
                              controller.onRefresh();
                            }
                          }

                      },
                    );
                  },
                  itemCount: controller.msgs.length,
              ),
            ),
          ),
        ),
      ),
    );
  }
}
