part of book_category;

class BuildItem extends StatelessWidget {
  final ChapterModel model;
  const BuildItem({
    Key? key,
    required this.model
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Column(
      children: [
        /// 章节名称容器
        Container(
          margin: const EdgeInsets.symmetric(horizontal: 15),
          child: Row(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: [
              Text(model.name??'',style: const TextStyle(fontSize: 14,color: Colours.c3,fontWeight: Fonts.medium,height: 1.6),),
              Container(
                width: 14,
                height: 4,
                color: Colors.cyan,
              )
            ],
          )
        ),
        /// 节的名称容器
        Visibility(
          visible: true,
            child: ListView.builder(
              shrinkWrap: true,
              physics: const NeverScrollableScrollPhysics(),
                itemBuilder: (BuildContext context, int index){
                  return _buildSection(model.children![index]);
                },
                itemCount: model.children!.length,
            )
        )
      ],
    );
  }

  Widget _buildSection(ChapterModel model){
    return Container(
      margin: const EdgeInsets.only(left: 60),
      child: Text(model.name??'',style: const TextStyle(fontSize: 12,color: Colours.c3,height: 1.6),),
    );
  }
}
