part of user_order_evaluate;


/// 订单评价
class UserOrderEvaluateController extends GetxController {
  late OrderInfoModel orderInfoModel = OrderInfoModel();
  String  orderNum;
  UserOrderEvaluateController(this.orderNum); // 已完成订单
  TextEditingController commentsInput = TextEditingController();
  late List<TextEditingController> _commentsControllers;
  final FocusNode  _focusNode = FocusNode();
  // 按钮是否可用
  bool  _enable = false;
  bool get enable => _enable;

  @override
  void onReady() {
    getOrderInfo();
    super.onReady();
  }

  /// 获取订单信息
  Future<void> getOrderInfo() async {
    orderInfoModel = await MineAPI.getOrderInfo(orderNum: orderNum);
    _commentsControllers = List.generate(
      orderInfoModel.bookList!.length,
          (index) => TextEditingController(text: orderInfoModel.bookList![index].comments.toString()),
    );
    update();
  }

  /// 上传评价
  void UpOrderEvaluate(String evaluate) async {
    final result = await MineAPI.UpOrderEvaluate(evaluate: evaluate);
    if (result) {
      Toast.show('评价成功');
      update();
    }
  }

  void setCanClick({num double=0}){
    if (double > 0){
      _enable = true;
    }
    else{
      _enable = false;
    }
    update();
  }

  void updateText(String text){
    commentsInput =TextEditingController(text: text);
    // update();
  }

  @override
  void onClose() {
    commentsInput.dispose();
    _focusNode.dispose();
    super.onClose();
  }
}
