part of mine;


class MinePage extends StatefulWidget {
  const MinePage({Key? key}) : super(key: key);

  @override
  State<MinePage> createState() => _MinePageState();
}

class _MinePageState extends State<MinePage> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<MineController>(
      init: MineController(),
        builder:(controller) => Scaffold(
          appBar: CustomAppBar(
            backgroundColor: Colors.transparent,
            actions: [
              CustomButton.icon(
                padding: EdgeInsets.zero,
                backgroundColor: Colors.transparent,
                icon: const Icon(Ionicons.timer),
                onPressed: () => context.pushNamed(Routes.coin),
              ),
              CustomButton.icon(
                padding: EdgeInsets.zero,
                backgroundColor: Colors.transparent,
                icon: const Icon(Ionicons.settings),
                onPressed: () => context.pushNamed(Routes.msgs),
              ),
              CustomButton.icon(
                padding: EdgeInsets.zero,
                backgroundColor: Colors.transparent,
                icon: const Icon(Ionicons.notifications),
                onPressed: () => context.pushNamed(Routes.msgs),
              ),
            ],
          ),
          body: SingleChildScrollView(
            child: Container(
              margin: EdgeInsets.symmetric(horizontal: AppTheme.margin),
              child: Column(
                children: [
                  BuildUser(onTap: (){
                    context.pushNamed(Routes.userInfo);
                  },),
                  Gaps.vGaps10,
                  BuildRead(items: ['1','2','3','4'],),
                  Gaps.vGaps10,
                  BuildBanner(items: ['111','222','333'],),
                  Gaps.vGaps10,
                  BuildAccount(items: ['1','11','紫荆币','1111'],),
                  Gaps.vGaps10,
                  Container(
                    decoration: BoxDecoration(
                      borderRadius: BorderRadius.circular(8),
                      color: Colors.cyan,
                    ),
                    child: Column(
                      children: [
                        _buildItem('账户安全', ''),
                        Container(color: Colours.cLine,margin: EdgeInsets.symmetric(horizontal: 15),height: 1,),
                        _buildItem('意见反馈', ''),
                        Container(color: Colours.cLine,margin: EdgeInsets.symmetric(horizontal: 15),height: 1,),
                        _buildItem('关于我们', ''),
                      ],
                    ),
                  ),
                ],
              ),
            ),
          ),
        ),
    );
  }

  Widget _buildItem(String title, String linkTo,{VoidCallback? onTap}) {
    return GestureDetector(
      onTap: (){
        if (linkTo.isNotEmpty){
          context.pushNamed(linkTo);
          if (onTap !=null) onTap;
        }
      },
      child: Container(
        padding: EdgeInsets.only(left: 18,right: 15),
        height: 42,
        child: Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          crossAxisAlignment: CrossAxisAlignment.center,
          children: [
            Text('$title',style: TextStyle(fontSize: 14,color: Colours.c3,),),
            Container(
              width: 5,
              height: 8,
              color: Colors.cyan,
            )
          ],
        ),
      ),
    );
  }

}
