part of study_report;

class BuildCard extends StatelessWidget {
  final ReportModel model;
  const BuildCard({
    Key? key,
    required this.model
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Stack(
      children: [
        Container(
          child: Image.asset(
            'assets/images/report_bg.png',
            width: double.infinity,
            fit: BoxFit.contain,
          ),
        ),
        Positioned(
            left: 0,
            top: 0,
            right: 0,
            child: Container(
              padding: EdgeInsets.only(left: 17.5.w,top:25.w,right: 20.w,bottom: 20.w),
              child: Row(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                crossAxisAlignment: CrossAxisAlignment.end,
                children: [
                  Expanded(
                    child: Column(
                      mainAxisAlignment: MainAxisAlignment.start,
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Text(model.bookName??'',style: TextStyle(fontSize: 18.w,height: 1.4,color: Colors.white,fontWeight: Fonts.boldSemi),),
                        Gaps.vGaps15,
                        Row(
                          children: [
                            Text('学习总进度',style: TextStyle(fontSize: 15.w,height: 1.4,color: Colors.white),),
                            Gaps.hGaps15,
                            Text(model.progress??'',style: TextStyle(fontSize: 16.w,height: 1.4,color: Colors.white,fontWeight: Fonts.boldSemi),),
                          ]
                        ),
                        Gaps.vGaps10,
                        Row(
                            children: [
                              Text('学习总时长',style: TextStyle(fontSize: 15.w,height: 1.4,color: Colors.white),),
                              Gaps.hGaps15,
                              Text('${model.readSecond??''}分钟',style: TextStyle(fontSize: 16.w,height: 1.4,color: Colors.white,fontWeight: Fonts.boldSemi),),
                            ]
                        ),
                        Gaps.vGaps10,
                        Text('上次读到',style: TextStyle(fontSize: 15.w,height: 1.4,color: Colors.white),),
                        Gaps.vGaps5,
                        Text(model.lastChapter??'',style: TextStyle(fontSize: 16.w,height: 1.4,color: Colors.white,fontWeight: Fonts.boldSemi),maxLines: 1,overflow: TextOverflow.ellipsis,),
                      ]
                    ),
                  ),
                  Container(
                    height: 120.w,
                    width: 100.w,
                    child: CustomImage.network(url: model.img??''),
                  )
                ],
              ),
            )
        )
      ],
    );
  }
}
