part of mine;


class MinePage extends StatefulWidget {
  const MinePage({Key? key}) : super(key: key);

  @override
  State<MinePage> createState() => _MinePageState();
}

class _MinePageState extends State<MinePage> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<MineController>(
      init: MineController(),
        builder:(controller) => Scaffold(
          backgroundColor:Colours.cF9,
          appBar: CustomAppBar(
            backgroundColor: Colors.transparent,
            actions: [
              CustomButton.icon(
                padding: EdgeInsets.zero,
                backgroundColor: Colors.transparent,
                icon: Image.asset(
                  'assets/images/read_history.png',
                ),
                onPressed: () => context.pushNamed(Routes.studyHistory),
              ),
              CustomButton.icon(
                padding: EdgeInsets.zero,
                backgroundColor: Colors.transparent,
                icon: Image.asset(
                  'assets/images/set.png',
                ),
                onPressed: () => context.pushNamed(Routes.msgs),
              ),
              GestureDetector(
                onTap: (){
                  context.pushNamed(Routes.msgs);
                  // controller.logout(context);
                },
                child: badges.Badge(
                  position: badges.BadgePosition.topEnd(top: -5, end: 0),
                  showBadge: controller.num == 0?false:true,
                  badgeContent: Text(controller.num.toString(),style: const TextStyle(fontSize: 7,color: Colors.white),),
                  badgeStyle: const badges.BadgeStyle(
                      badgeColor: AppTheme.primary,
                      shape: badges.BadgeShape.circle
                  ),
                  child: CustomButton.icon(
                    padding: EdgeInsets.zero,
                    backgroundColor: Colors.transparent,
                    icon: Image.asset(
                      'assets/images/msg_black.png',
                    ),
                    // onPressed: () => context.pushNamed(Routes.msgs),
                  ),
                ),
              )
            ],
          ),
          body: Container(
            color: Colours.cF9,
            child: SingleChildScrollView(
              child: Container(
                margin: const EdgeInsets.symmetric(horizontal: AppTheme.margin),
                child: Column(
                  children: [
                    BuildUser(userInfo:controller.userInfo,onTap: (){
                      context.pushNamed(Routes.userInfo);
                    },),
                    Gaps.vGaps10,
                    BuildRead(items: controller.reads),
                    controller.ads.isNotEmpty?Gaps.vGaps10:SizedBox(),
                    controller.ads.isNotEmpty?
                    Container(
                      color: Colors.transparent,
                      padding: const EdgeInsets.symmetric(horizontal: 10),
                      child: BuildBanner(items:controller.ads),
                    ):const SizedBox(),
                    Gaps.vGaps10,
                    BuildAccount(items:controller.accounts,),
                    Gaps.vGaps10,
                    Container(
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(8),
                        color: const Color(0xFFF9F9F9),
                        boxShadow: [
                          BoxShadow(
                            color: const Color(0xFFC7C7C7).withOpacity(0.5),
                            offset: const Offset(3, 0),
                            blurRadius: 10.w,
                            spreadRadius: 0.w,
                          ),
                        ],
                      ),
                      child: Column(
                        children: [
                          _buildItem('账户安全', ''),
                          Container(color: Colours.cLine,margin: EdgeInsets.symmetric(horizontal: 15),height: 1,),
                          _buildItem('意见反馈', ''),
                          Container(color: Colours.cLine,margin: EdgeInsets.symmetric(horizontal: 15),height: 1,),
                          _buildItem('关于我们', ''),
                        ],
                      ),
                    ),
                  ],
                ),
              ),
            ),
          ),
        ),
    );
  }

  Widget _buildItem(String title, String linkTo,{VoidCallback? onTap}) {
    return GestureDetector(
      onTap: (){
        if (linkTo.isNotEmpty){
          context.pushNamed(linkTo);
          if (onTap !=null) onTap;
        }
      },
      child: Container(
        padding: EdgeInsets.only(left: 18,right: 15),
        height: 42,
        child: Row(
          mainAxisAlignment: MainAxisAlignment.spaceBetween,
          crossAxisAlignment: CrossAxisAlignment.center,
          children: [
            Text('$title',style: TextStyle(fontSize: 14,color: Colours.c3,),),
            Container(
              width: 5,
              height: 8,
              color: Colors.cyan,
            )
          ],
        ),
      ),
    );
  }

}
