part of book_category;


class BookCategoryPage extends StatefulWidget {
  final List <ChapterModel> chapters;
  final String bookId;
  final BookDetailModel bookDetails;
  final void Function(ChapterModel model) onTap;
  const BookCategoryPage({
    Key? key,
    required this.chapters,
    required this.bookId,
    required this.bookDetails,
    required this.onTap
  }) : super(key: key);

  @override
  State<BookCategoryPage> createState() => _BookCategoryPageState();
}

class _BookCategoryPageState extends State<BookCategoryPage> {
  @override
  Widget build(BuildContext context) {
    return Column(
      children: [
        Expanded(
          child: ListView.builder(
              itemBuilder:(BuildContext context, int index){
                return BuildItem(
                  model: widget.chapters[index],
                  bookId: widget.bookId,
                  bookDetails: widget.bookDetails,
                  onTap: (ChapterModel model){
                    widget.onTap(model);
                  },
                );
              },
              itemCount: widget.chapters.length,
          ),
        ),
      ],
    );
  }
}
