part of models;

class PayModel {
  PayModel({
    required this.type,
    required this.name,
    required this.icon,
    required this.selected
  });


  int type;
  String name;
  String icon;
  bool selected;

}

/// 可使用积分模型
class CreditPointModel {
  CreditPointModel({
    this.integral,
    this.onePointDeductionAmount,
    this.integralUseLimit,
    this.integralSwitch,
    this.deductibleAmount,
    this.deductibleIntegral,});

  CreditPointModel.fromJson(dynamic json) {
    integral = json['integral'];
    onePointDeductionAmount = json['one_point_deduction_amount'];
    integralUseLimit = json['integral_use_limit'];
    integralSwitch = json['integral_switch'];
    deductibleAmount = json['deductible_amount'];
    deductibleIntegral = json['deductible_integral'];
  }
  num? integral;
  String? onePointDeductionAmount;
  String? integralUseLimit;
  String? integralSwitch;
  String? deductibleAmount;
  num? deductibleIntegral;
  CreditPointModel copyWith({  num? integral,
    String? onePointDeductionAmount,
    String? integralUseLimit,
    String? integralSwitch,
    String? deductibleAmount,
    num? deductibleIntegral,
  }) => CreditPointModel(  integral: integral ?? this.integral,
    onePointDeductionAmount: onePointDeductionAmount ?? this.onePointDeductionAmount,
    integralUseLimit: integralUseLimit ?? this.integralUseLimit,
    integralSwitch: integralSwitch ?? this.integralSwitch,
    deductibleAmount: deductibleAmount ?? this.deductibleAmount,
    deductibleIntegral: deductibleIntegral ?? this.deductibleIntegral,
  );
  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['integral'] = integral;
    map['one_point_deduction_amount'] = onePointDeductionAmount;
    map['integral_use_limit'] = integralUseLimit;
    map['integral_switch'] = integralSwitch;
    map['deductible_amount'] = deductibleAmount;
    map['deductible_integral'] = deductibleIntegral;
    return map;
  }

}

/// 优惠券和 积分是否展示模型
class ShowModel {
  ShowModel({
    this.couponSwitch,
    this.integralSwitch,
    this.membersBean,
  });

  ShowModel.fromJson(dynamic json) {
    couponSwitch = json['coupon_switch'];
    integralSwitch = json['integral_switch'];
    membersBean = json['members_bean'];
  }
  String? couponSwitch;
  String? integralSwitch;
  String? membersBean;
  ShowModel copyWith({  String? couponSwitch,
    String? integralSwitch,
    String? membersBean,
  }) => ShowModel(  couponSwitch: couponSwitch ?? this.couponSwitch,
    integralSwitch: integralSwitch ?? this.integralSwitch,
    membersBean: membersBean ?? this.integralSwitch
  );
  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['coupon_switch'] = couponSwitch;
    map['integral_switch'] = integralSwitch;
    map['members_bean'] = membersBean;
    return map;
  }

}

class CouponListModel {
  CouponListModel({
    this.list,
    this.total,});

  CouponListModel.fromJson(dynamic json) {
    if (json['list'] != null) {
      list = [];
      json['list'].forEach((v) {
        list?.add(CouponModel.fromJson(v));
      });
    }
    total = json['total'];
  }
  List<CouponModel>? list;
  num? total;
  CouponListModel copyWith({  List<CouponModel>? list,
    num? total,
  }) => CouponListModel(  list: list ?? this.list,
    total: total ?? this.total,
  );
  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    if (list != null) {
      map['list'] = list?.map((v) => v.toJson()).toList();
    }
    map['total'] = total;
    return map;
  }

}

/// 优惠券可使用和不可使用数量
class CouponNumModel {
  CouponNumModel({
    this.availableNum,
    this.unavailableNum,});

  CouponNumModel.fromJson(dynamic json) {
    availableNum = json['available_num'];
    unavailableNum = json['unavailable_num'];
  }
  num? availableNum;
  num? unavailableNum;
  CouponNumModel copyWith({  num? availableNum,
    num? unavailableNum,
  }) => CouponNumModel(  availableNum: availableNum ?? this.availableNum,
    unavailableNum: unavailableNum ?? this.unavailableNum,
  );
  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['available_num'] = availableNum;
    map['unavailable_num'] = unavailableNum;
    return map;
  }

}

/// 创建订单模型
class PayOrderModel {
  PayOrderModel({
    this.appid,
    this.partnerid,
    this.prepayid,
    this.package,
    this.noncestr,
    this.timestamp,
    this.sign,
    this.ordersnum,
    this.encryptionOrder,
    this.code,
    String? msg,
  });

  PayOrderModel.fromJson(dynamic json) {
    appid = json['appid'];
    partnerid = json['partnerid'];
    prepayid = json['prepayid'];
    package = json['package'];
    noncestr = json['noncestr'];
    timestamp = json['timestamp'];
    sign = json['sign'];
    ordersnum = json['ordersnum'];
    encryptionOrder = json['encryption_order'];
    code = json['code'];
    msg = json['msg'];
  }
  String? appid;
  String? partnerid;
  String? prepayid;
  String? package;
  String? noncestr;
  num? timestamp;
  String? sign;
  String? ordersnum;
  String? encryptionOrder;
  num? code;
  String? msg;
  PayOrderModel copyWith({  String? appid,
    String? partnerid,
    String? prepayid,
    String? package,
    String? noncestr,
    num? timestamp,
    String? sign,
    String? ordersnum,
    String? encryptionOrder,
    num? code,
    String? msg,
  }) => PayOrderModel(  appid: appid ?? this.appid,
    partnerid: partnerid ?? this.partnerid,
    prepayid: prepayid ?? this.prepayid,
    package: package ?? this.package,
    noncestr: noncestr ?? this.noncestr,
    timestamp: timestamp ?? this.timestamp,
    sign: sign ?? this.sign,
    ordersnum: ordersnum ?? this.ordersnum,
    encryptionOrder: encryptionOrder ?? this.encryptionOrder,
    code: code ?? this.code,
    msg: msg?? this.msg,
  );
  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['appid'] = appid;
    map['partnerid'] = partnerid;
    map['prepayid'] = prepayid;
    map['package'] = package;
    map['noncestr'] = noncestr;
    map['timestamp'] = timestamp;
    map['sign'] = sign;
    map['ordersnum'] = ordersnum;
    map['encryption_order'] = encryptionOrder;
    map['code'] = code;
    map['msg'] = msg;
    return map;
  }

}