part of user_order_awaiting;

class UserOrderAwaitingPage extends StatefulWidget {
  const UserOrderAwaitingPage({Key? key /*, required this.userInfo*/
      })
      : super(key: key);

  @override
  State<UserOrderAwaitingPage> createState() => _UserOrderAwaitingState();
}

class _UserOrderAwaitingState extends State<UserOrderAwaitingPage> {
/*  late num? selectedGender ; // 选中的性别
  @override
  void initState() {
    super.initState();
    selectedGender = widget.userInfo.sex;
    // 在这里可以使用 localVariable 进行操作
  }*/

  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: () async {
        context.pop(true);
        return false;
      },
      child: GetBuilder<UserOrderAwaitingController>(
          init: UserOrderAwaitingController(),
          builder: (controller) => Scaffold(
                appBar: CustomAppBar(
                  title: const Text('等待付款'),
                  actions: [],
                ),
                body: Column(
                  children: [
                    Container(
                      width: double.infinity,
                      margin: EdgeInsets.symmetric(
                          horizontal: AppTheme.margin,
                          vertical: AppTheme.margin),
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(8.w),
                        color: Colors.white,
                        boxShadow: [
                          BoxShadow(
                            color: Colours.cC7.withOpacity(0.5),
                            offset: Offset(3.w, 0),
                            blurRadius: 10.w,
                            spreadRadius: 0.w,
                          ),
                        ],
                      ),
                      child: ClipRRect(
                        borderRadius: BorderRadius.circular(8.w),
                        child: Column(
                          mainAxisAlignment: MainAxisAlignment.start,
                          mainAxisSize: MainAxisSize.min,
                          children: [
                            Padding(
                              padding: EdgeInsets.only(
                                  left: 12.0.w, top: 12.0.w, bottom: 12.0.w),
                              child: Row(
                                mainAxisAlignment: MainAxisAlignment.start,
                                crossAxisAlignment: CrossAxisAlignment.start,
                                children: [
                                  Image.network(
                                    'http://zxts-user-file.oss-cn-beijing.aliyuncs.com/2024-01/20/eb167c2f59f7e34c0ef94a9f1ce736ee64d76a11.jpg',
                                    // 用实际图片链接替换
                                    fit: BoxFit.cover, // 设置适应方式为充满
                                    width: 72.0.w,
                                    height: 86.0.w,
                                  ),
                                  Expanded(
                                    child: Padding(
                                      padding: EdgeInsets.only(
                                          left: 12.0.w,
                                          top: 5.5.w,
                                          right: 23.5.w),
                                      child: Column(
                                        mainAxisAlignment:
                                            MainAxisAlignment.spaceBetween,
                                        crossAxisAlignment:
                                            CrossAxisAlignment.end, // 下面的Text靠左
                                        children: [
                                          Text(
                                            "一想到还有95%的问题留给人类，我就放一想到还有95%的问题留给问题留给",
                                            style: TextStyle(
                                              color: Colours.c3,
                                              fontWeight: Fonts.bold,
                                              fontSize: 13.w,
                                            ),
                                            maxLines: 2,
                                            overflow: TextOverflow
                                                .ellipsis, // 超过部分显示省略号
                                          ),
                                          SizedBox(height: 25.5.w),
                                          Text(
                                            "需付款 ¥${controller.orderCompletedInfo.price}",
                                            style: TextStyle(
                                              color: Colours.cAB1941,
                                              fontWeight: Fonts.bold,
                                              fontSize: 14.w,
                                            ),
                                          ),
                                        ],
                                      ),
                                    ),
                                  ),
                                ],
                              ),
                            ),
                            Container(
                              color: Colours.cLine,
                              margin: EdgeInsets.only(
                                  left: 10.w, right: 10.w, bottom: 12.w),
                              height: 1.w,
                            ),
                            Container(
                              padding: EdgeInsets.only(
                                  left: 11.5.w, bottom: 8.w, right: 23.5.w),
                              child: Column(
                                mainAxisAlignment:
                                    MainAxisAlignment.spaceEvenly,
                                children:
                                    controller.orderAwaitings.map((model) {
                                  return Padding(
                                    padding: EdgeInsets.only(top: 12.w),
                                    child: Row(
                                      mainAxisAlignment:
                                          MainAxisAlignment.spaceBetween,
                                      children: [
                                        Text(
                                          model.name,
                                          style: TextStyle(
                                              fontSize: 13.w,
                                              height: 1.6.w,
                                              color: Colours.c9),
                                        ),
                                        Text(
                                          model.value.toString(),
                                          style: TextStyle(
                                              fontSize: 13.w,
                                              height: 1.6.w,
                                              color: Colours.c3),
                                        ),
                                      ],
                                    ),
                                  );
                                }).toList(),
                              ),
                            ),
                            SizedBox(
                              height: 13.5.w,
                            ),
                          ],
                        ),
                      ),
                    ),
                    SizedBox(
                      height: 39.w,
                    ),
                    Container(
                      margin: EdgeInsets.symmetric(horizontal: 15.w),
                      height: 40.w,
                      decoration: BoxDecoration(
                          color: AppTheme.primary,
                          borderRadius: BorderRadius.circular(180.w),
                          border:
                              Border.all(color: Colours.cC31F4C, width: 0.5.w)),
                      child: Center(
                        child: GestureDetector(
                            onTap: () {
                              // print("保存昵称");
                              context.pushNamed(Routes.orderEvaluate);
                            },
                            child: Text(
                              '立即支付 ¥${controller.orderCompletedInfo.price}',
                              style: TextStyle(
                                  fontWeight: Fonts.medium,
                                  fontSize: 14.w,
                                  color: Colours.cFF),
                            )),
                      ),
                    ),
                    SizedBox(
                      height: 11.5.w,
                    ),
                    GestureDetector(
                      onTap: () {
                        print('取消订单');
                        CustomDialog.show(context: context, builder:Text('sdfsf') as WidgetBuilder);
                        // Navigator.pop(context);
                      },
                      child: Text(
                        '取消订单',
                        style: TextStyle(
                            fontWeight: Fonts.medium,
                            fontSize: 15.w,
                            color: Colours.c9),
                      ),
                    ),
                  ],
                ),
              )),
    );
  }
}
