part of mine;



class MineController extends GetxController {

  // 广告数据
  List<AdModel> ads = [];
  // 个人信息数据
  Map<String,dynamic> userInfo = {'name':'','phone':''};
  // 笔记 讨论 错题 收藏
  List<ReadModel> reads = [];
  // 我的账户数据
  List<ReadModel> accounts = [];

  // 消息未读数
  int num = 0;


  @override
  void onReady() {
    _getAds();
    _getNums();
    getInfo();
    super.onReady();
  }


  /// 获取广告数据
  void _getAds() async {
    ads = await CommonAPI.list(type: '4');
    update();
  }

  /// 消息未读数
  void _getNums() async {
    num = await CommonAPI.num();
    update();
  }

  /// 获取个人信息数据
  void getInfo() async {
    userInfo = await MineAPI.userInfo();
    reads = [
      ReadModel(name: '笔记',value: userInfo['note_nums'].toString(),link: Routes.note),
      ReadModel(name: '讨论',value: userInfo['comment_nums'].toString()),
      ReadModel(name: '错题',value: userInfo['wrong_nums'].toString(),link: Routes.wrong),
      ReadModel(name: '收藏',value: userInfo['collect_nums'].toString(),link: Routes.love)
    ];
    accounts = [
      ReadModel(name: '优惠券',value: userInfo['coupon_nums'].toString(),icon: 'assets/images/coupon.png'),
      ReadModel(name: '积分',value: userInfo['integral_nums'].toString(),link: Routes.coin,icon: 'assets/images/point.png'),
      ReadModel(name: '紫金币',value: userInfo['bean_nums'].toString(),link: Routes.coin,icon: 'assets/images/coin.png'),
      ReadModel(name: '订单',value: userInfo['orders_nums'].toString(),icon: 'assets/images/order.png')
    ];
    update();
  }

}