part of pay_coupon;



class PayCouponPage extends StatefulWidget {
  final BookPayController payController;
  const PayCouponPage({
    Key? key,
    required this.payController
  }) : super(key: key);

  @override
  State<PayCouponPage> createState() => _PayCouponPageState();
}

class _PayCouponPageState extends State<PayCouponPage>  with SingleTickerProviderStateMixin{

  List <Widget> tabs= [];
  late TabController tabController;

  @override
  void initState() {
    tabs = [
      Tab(text: '可用(${widget.payController.couponNumModel.availableNum})',),
      Tab(text: '不可用(${widget.payController.couponNumModel.unavailableNum})',),
    ];
    tabController = TabController(length:tabs.length, vsync: this);
    super.initState();
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
        appBar: AppBar(
          centerTitle: true,
          title: const Text('选择优惠券'),
        ),
        body: Column(
          children: [
            TabBar(
              labelColor: Colours.c3,
              labelStyle: TextStyle(fontSize: 15.w,height: 1.4,fontWeight: Fonts.medium),
              unselectedLabelColor: Colours.c9,
              unselectedLabelStyle: TextStyle(fontSize: 15.w,height: 1.4),
              indicatorSize: TabBarIndicatorSize.label,
              indicatorColor: AppTheme.primary,
              tabs:tabs,
              physics: const NeverScrollableScrollPhysics(),
              controller: tabController,
            ),
            Expanded(
              child: TabBarView(
                controller: tabController,
                children: List.generate(tabs.length, (index){
                  return CouponPage(tag:'${1-index}',payController: widget.payController,);
                })
              ),
            ),
          ],
        ),
      );
  }

}

class CouponPage extends StatefulWidget {
  final String tag;
  final BookPayController payController;
  const CouponPage({
    Key? key,
    required this.tag,
    required this.payController
  }) : super(key: key);

  @override
  State<CouponPage> createState() => _CouponPageState();
}

class _CouponPageState extends State<CouponPage> with AutomaticKeepAliveClientMixin{
  @override
  Widget build(BuildContext context) {
    return  GetBuilder<PayCouponController>(
      tag: widget.tag,
      init: PayCouponController(widget.tag,widget.payController),
      builder: (controller) =>CustomPullScrollView(
        controller: controller.refreshController,
        onRefresh: controller.onRefresh,
        onLoading: controller.onLoading,
        child: ListView.builder(
          itemBuilder: (BuildContext context, int index){
            CouponModel model = controller.coupons[index];
            return BuildItem(model:model,useTap: (){
              Console.log('选择优惠券--------------------------------${model.couponRecId}');
              widget.payController.setUseCoupon(model);
              context.pop();
            },);
          },
          itemCount: controller.coupons.length,
        ),
      ),
    );
  }

  @override
  bool get wantKeepAlive => true;
}





