part of book_pay;

class BookPayPage extends StatefulWidget {
  final List<CourseModel> buy;
  const BookPayPage({
    Key? key,
    required this.buy
  }) : super(key: key);

  @override
  State<BookPayPage> createState() => _BookPayPageState();
}

class _BookPayPageState extends State<BookPayPage> {

  @override
  Widget build(BuildContext context) {
    return GetBuilder<BookPayController>(
      init: BookPayController(widget.buy),
      builder: (controller) => Scaffold(
        backgroundColor: Colours.cF9,
        appBar: AppBar(title: const Text('支付'),),
        body: SingleChildScrollView(
          child: Column(
            children: [
              ListView.builder(
                physics: const NeverScrollableScrollPhysics(),
                shrinkWrap:true,
                itemBuilder: (BuildContext context, int index){
                  return BuildItem(model: controller.buy[index],);
                },
                itemCount: controller.buy.length,
              ),

              SizedBox(height: 10.w,),
              Container(
                margin: EdgeInsets.only(left: 10.w,right: 10.w),
                decoration: BoxDecoration(
                    borderRadius:BorderRadius.circular(8.w),
                    color: Colors.white,
                    boxShadow: [
                      BoxShadow(
                        color: Colours.cC7.withOpacity(0.5),
                        spreadRadius: 2.w,
                        blurRadius: 5.w,
                        offset: Offset(3.w, 0), // changes the position of the shadow
                      ),
                    ]
                ),
                child: Column(
                  children: [
                    GestureDetector(
                      child: _buildWidget(title: '优惠券',icon: 'assets/images/pay_coupon.png',),
                      onTap: (){
                        context.pushNamed(Routes.payCoupon);
                      },
                    ),
                    Container(height: 0.5.w,color: Colours.cF0,margin: EdgeInsets.only(left: 10.w),),
                    GestureDetector(
                      child: _buildWidget(title: '积分抵扣',icon: 'assets/images/pay_point.png',),
                      onTap: (){
                          context.pushNamed(Routes.creditPoints);
                      },
                    ),
                  ],
                ),
              ),
              Container(
                margin: EdgeInsets.only(left: 10.w,right: 10.w,top: 10.w),
                decoration: BoxDecoration(
                    borderRadius:BorderRadius.circular(8.w),
                    color: Colors.white,
                    boxShadow: [
                      BoxShadow(
                        color: Colours.cC7.withOpacity(0.5),
                        spreadRadius: 2.w,
                        blurRadius: 5.w,
                        offset: const Offset(3, 0), // changes the position of the shadow
                      ),
                    ]
                ),
                child: ListView.builder(
                  physics: const NeverScrollableScrollPhysics(),
                  padding: const EdgeInsets.symmetric(horizontal: 10),
                  shrinkWrap:true,
                  itemBuilder: (BuildContext context, int index){
                    PayModel model = controller.pays[index];
                    return GestureDetector(
                      onTap: (){
                        controller.setPayModel(model);
                      },
                        child: BuildPayWay(model:model,));
                  },
                  itemCount: controller.pays.length,
                ),
              ),
            ],
          ),
        ),
        bottomNavigationBar: SafeArea(child: BuildPayCount()),
      ),
    );
  }


  Widget _buildWidget({
    required String title,
    required String icon,
  }){
    return Container(
      margin: EdgeInsets.only(left: 13.w,right: 13.w),
      color: Colors.white,
      child: Row(
        mainAxisAlignment: MainAxisAlignment.spaceBetween,
        children: [
          Row(
            children: [
              Container(
                margin: EdgeInsets.symmetric(vertical: 12.w),
                // color: Colors.cyan,
                width:20.w,
                height:20.w,
                child: Image.asset(icon),
              ),
              SizedBox(width: 7.w,),
              Text(title,style:  TextStyle(fontSize: 14.w,color: Colours.c3,height: 1.1)),
            ],
          ),
          SizedBox(
            // color: Colors.cyan,
            width:5.w,
            height:8.w,
            child: Image.asset('assets/images/right_arrow.png'),
          ),
        ],
      ),
    );
  }

}
