part of web;

class ReadController extends FullLifeCycleController with GetSingleTickerProviderStateMixin{
  late AnimationController _controller;
  bool _show = false;

  bool get show => _show;
  void setShow(bool value) {
    _show = !value;
    if (_show) {
      /// 显示状态栏
      SystemChrome.setEnabledSystemUIMode(SystemUiMode.edgeToEdge);
      /// 开启动画
      _controller.forward();
    }
    else {
      /// 不显示状态栏
      SystemChrome.setEnabledSystemUIMode(SystemUiMode.immersiveSticky);
      /// 收回动画
      _controller.reverse();
    }
    update();
  }


  AnimationController get controller => _controller;


  @override
  void onInit() {
    /// 默认不显示状态栏
    SystemChrome.setEnabledSystemUIMode(SystemUiMode.immersiveSticky);
    /// 初始化
    _controller = AnimationController(
      vsync: this,
      duration: const Duration(milliseconds: 100),
    );
    super.onInit();
  }

  @override
  void onClose() {
    _controller.dispose();
    super.onClose();
  }

  void onResumed(){
    print('onResumed');
  }
  void onPaused(){
    print('onPaused');
  }
  void onInactive(){
    print('onInactive');
  }
  void onDetached(){
    print('onDetached');
  }
}