part of apis;

abstract class ShopAPI {

  /// 1、加入书架
  ///
  static Future <bool> addCart({
    required String  bookId,
  }) async {
    final result = await HttpService.to.post(
      '/v1/orders/Orders/addCart',
      params: {
        'book_id':bookId,
      },
    );
    if (result.data is Map && result.data['is_success'] == 1){
      return true;
    }
    return false;
  }

  /// 2、删除书架
  ///
  static Future <bool> delCart({
    required String cartId,
  }) async {
    final result = await HttpService.to.post(
      '/v1/orders/Orders/delCart',
      params: {
        'cart_id':cartId,
      },
    );
    if (result.data is Map && result.data['is_success'] == 1){
      return true;
    }
    return false;
  }

  /// 3、书架列表
  static Future <List<CourseModel>> cart({
    int page = 1,
    int limit = 10,
  }) async {
    final result = await HttpService.to.post(
      '/v1/orders/Orders/getCartListAll',
      params: {
        'page': page,
        'page_size': limit,
      },
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index){
      return CourseModel.fromJson(result.data['list'][index]);
    });
  }

  /// 4、获取使用积分
  ///
  static Future <CreditPointModel> creditPoints({
    required String price,
  }) async {
    final result = await HttpService.to.post(
      '/v1/coupon/Coupon/getIntegral',
      params: {
        'price': price,
      },
    );
    if (result.data is! Map ) return CreditPointModel();
    return CreditPointModel.fromJson(result.data);
  }

  /// 5、优惠券和积分是否展示
  ///
  static Future <ShowModel> show() async {
    final result = await HttpService.to.post(
      '/v1/orders/Orders/getSetting',
      params: {},
    );
    if (result.data is! Map ) return ShowModel();
    return ShowModel.fromJson(result.data);
  }

  /// 6、 支付时选的优惠券列表
  static Future<CouponListModel> coupon({
    int page = 1,
    int limit = 10,
    required String type,
    required String price
  }) async {
    final result = await HttpService.to.post(
      '/v1/coupon/Coupon/getCouponAll',
      params: {'page': page, 'page_size': limit, 'type': type,'price':price},
    );
    if (result.data is! Map ) return CouponListModel();
    return CouponListModel.fromJson(result.data);
  }


}