part of pay_coupon;

class PayCouponController extends GetxController with GetSingleTickerProviderStateMixin{
  final String tag;
  PayCouponController(this.tag);

  List <Widget>tabs = [
    const Tab(text: '可用',),
    const Tab(text: '不可用',),
  ];
  late TabController tabController = TabController(length:tabs.length, vsync: this);

  final EasyRefreshController refreshController = EasyRefreshController(
    controlFinishLoad: true,
    controlFinishRefresh: true,
  );
  CouponListModel couponListModel = CouponListModel();
  // 优惠券
  List <CouponModel> coupons = [];

  final int _limit = 10;
  int _page = 1;
  bool _noMore = false;

  final String price = '200';




  Future<void> _getCoupon([bool isRefresh = false]) async {
    if (isRefresh) _page = 1;
    // 网路请求
    final result = await ShopAPI.coupon(
      page: _page,
      limit: _limit,
      type: tag,
      price: price
    );

    tabs = [
      Tab(text: '可用(${tag =='0'?result.list!.length:''})',),
      Tab(text: '不可用(${tag =='1'?result.list!.length:''})',),
    ];

    // 如果是刷新 清理数据
    if (isRefresh) coupons.clear();
    coupons.addAll(result.list!);
    _page ++;
    _noMore = result.list!.length < _limit;
    update();

  }

  void onRefresh() async {
    try {
      await _getCoupon(true);
      refreshController.finishRefresh(IndicatorResult.success);
      refreshController.resetFooter();
    } catch (error) {
      print('--------------------------------$error');
      refreshController.finishRefresh(IndicatorResult.fail);
    }
  }

  void onLoading() async {
    if (_noMore) {
      refreshController.finishLoad(IndicatorResult.noMore);
      return;
    }
    try {
      await _getCoupon();
      refreshController.finishLoad();
    } catch (error) {
      refreshController.finishLoad(IndicatorResult.fail);
    }
  }
}