part of pay_coupon;

class BuildItem extends StatelessWidget {
  final CouponModel model;
  const BuildItem({
    Key? key,
    required this.model
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: EdgeInsets.only(left: 10.w,top: 10.w,right: 10.w),
        decoration: BoxDecoration(
          borderRadius: BorderRadius.circular(8.w),
          color:  Colors.white,
          boxShadow: [
            BoxShadow(
              color: const Color(0xFFC7C7C7).withOpacity(0.5),
              offset: Offset(3.w, 0),
              blurRadius: 10.w,
              spreadRadius: 0.w,
            ),
          ],
        ),
      child: Row(
        crossAxisAlignment: CrossAxisAlignment.center,
        children: [
          Stack(
            children: [
              Image.asset('assets/images/coupon_yes.png'),
              Positioned(
                left: 0.w,
                right: 0.w,
                bottom: 0.w,
                top: 0.w,
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.center,
                  children: [
                    RichText(
                      text: TextSpan(
                          children: <TextSpan>[
                            TextSpan(
                                text: '￥',
                                style: TextStyle(fontSize: 15.w,fontWeight: Fonts.boldSemi,height: 1.5,color: Colors.white)
                            ),
                            TextSpan(
                                text: '5',
                                style: TextStyle(fontSize: 40.w,fontWeight: Fonts.boldSemi,height: 1.5,color: Colors.white)
                            ),
                          ]
                      ),
                    ),
                    Text('满${model.normPrice}可用',style: TextStyle(fontSize: 11.w,height: 1.5,color: Colors.white),)
                  ],
                ),
              )
            ],
          ),
          Expanded(
            child: Container(
              margin: EdgeInsets.only(left:15.w,right: 15.w ),
              child: Row(
                mainAxisAlignment: MainAxisAlignment.spaceBetween,
                children: [
                  Column(
                    crossAxisAlignment: CrossAxisAlignment.start,
                    mainAxisAlignment: MainAxisAlignment.center,
                    children: [
                      Text(model.couponName??'',style: TextStyle(fontSize: 16.w,fontWeight: Fonts.medium,height: 1.5,color: Colours.c3),),
                      Gaps.vGaps5,
                      Text('满${model.normPrice}减${model.reducedPrice}元',style: TextStyle(fontSize: 12.w,height: 1.5,color: Colours.c9),),
                      Gaps.vGaps5,
                      Text('有效期',style: TextStyle(fontSize: 12.w,height: 1.5,color: Colours.c9),),
                    ],
                  ),
                  Container(
                    width: 65.w,
                    height: 24.w,
                    alignment: Alignment.center,
                    decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(15.w),
                        color: Colors.white,
                        border: Border.all(width: 1.w,color: AppTheme.primary)
                    ),
                    child: Text('立即使用',style: TextStyle(fontSize: 12.w,fontWeight: Fonts.medium,color: AppTheme.primary),),
                  )
                ],
              ),
            ),
          )

        ],
      )
    );
  }
}
