part of ad;

class AdPage extends StatefulWidget {
  final List<AdModel> ads;
  const AdPage({
    Key? key,
    required this.ads
  }) : super(key: key);

  @override
  State<AdPage> createState() => _AdPageState();
}

class _AdPageState extends State<AdPage> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<AdController>(
        init: AdController(context),
        builder:(controller) => Scaffold(
          body: Stack(
            fit: StackFit.expand,
            children: [
              GestureDetector(
                onTap: (){
                  context.pushNamed(Routes.adDetail,extra: widget.ads.first);
                },
                child: Container(
                  color: Colors.green,
                  child: CustomImage.network(url: widget.ads.first.pic??''),
                ),
              ),
              Positioned(
                top: 40.w,
                right: 20.w,
                child: GestureDetector(
                  onTap: (){
                    context.goNamed(Routes.main);
                  },
                  child: Container(
                    padding: EdgeInsets.symmetric(horizontal: 12.0.w, vertical: 8.0.w),
                    decoration: BoxDecoration(
                      color: Colors.black.withOpacity(0.6),
                      borderRadius: BorderRadius.circular(8.0.w),
                    ),
                    child: Text(
                      '跳过 ${controller._countdown} s',
                      style: TextStyle(color: Colors.white,fontSize:14.w,),
                    ),
                  ),
                )
              )
            ],
          )
        )

    );
  }
}
