part of user_discuss;

class UserDiscussPage extends StatefulWidget {
  const UserDiscussPage({Key? key}) : super(key: key);

  @override
  State<UserDiscussPage> createState() => _UserDiscussPageState();
}

class _UserDiscussPageState extends State<UserDiscussPage> {
  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: () async {
        context.pop(true);
        return false;
      },
      child: GetBuilder<UserDiscussController>(
        init: UserDiscussController(),
        builder:(controller)=> Scaffold(
          appBar: AppBar(
            centerTitle: true,
            title: const Text('讨论'),
          ),
          body: Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Container(
                  margin: EdgeInsets.only(left: 22.5.w,top: 16.w),
                  child: Text('共${controller.discuss.length}本书',style: TextStyle(fontSize: 13.w,height: 1.5,color: Colours.c6,fontWeight: Fonts.medium),)
              ),
              Expanded(
                child: CustomPullScrollView(
                  controller: controller.refreshController,
                  onRefresh: controller.onRefresh,
                  onLoading: controller.onLoading,
                  child:ListView.builder(
                    itemBuilder: (BuildContext context, int index){
                      return GestureDetector(
                        onTap: (){
                          context.pushNamed(Routes.discussDes,extra: controller.discuss[index]);
                        },
                          child: BuildItem(model: controller.discuss[index],index: index,num: controller.discuss.length,)
                      );
                    },
                    itemCount: controller.discuss.length,
                  )
                ),
              ),
            ],
          ),
        ),
      ),
    );
  }
}
