part of main;


class MainPage extends StatefulWidget {
  const MainPage({Key? key}) : super(key: key);

  @override
  State<MainPage> createState() => _MainPageState();
}

class _MainPageState extends State<MainPage> with WidgetsBindingObserver{

  @override
  void initState() {
    super.initState();
    WidgetsBinding.instance.addObserver(this);
  }


  @override
  void didChangePlatformBrightness() {
    super.didChangePlatformBrightness();
    AppTheme.setSystemStyle();
  }

  @override
  void dispose() {
    WidgetsBinding.instance.removeObserver(this);
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return GetBuilder<MainController>(
        init: MainController(),
        builder: (controller) => Scaffold(
          body: PageView(
            physics: const NeverScrollableScrollPhysics(),
            controller: controller.pageController,
            onPageChanged: controller.onPageChanged,
            children: const [
              CoursePage(),
              LibraryPage(),
              BookShopPage(),
              MinePage(),
            ],
          ),
          bottomNavigationBar: GetBuilder<MainController>(
            id: 'navigation',
            builder: (controller) => Container(
              decoration: BoxDecoration(
                color: Colors.white,
                boxShadow:[
                  BoxShadow(
                    color: const Color(0xFFE0E0E0).withOpacity(0.5),
                    spreadRadius: 0,
                    blurRadius: 4.5,
                    offset: const Offset(0, 0),
                  ),
                ],
              ),
              child: BottomNavigationBar(
                  currentIndex:controller.currentPage ,
                  onTap: (page){
                    if (page != 1 && !UserStore.to.isLogin) {
                      context.pushNamed(Routes.login);
                    } else {
                      controller.pageController.jumpToPage(page);
                    }
                    // controller.pageController.jumpToPage(page);
                  },
                  items:  [
                      BottomNavigationBarItem(
                          icon: Image.asset(
                            'assets/images/course.png',
                            width: 25,
                            height: 27.5,
                            fit: BoxFit.cover,
                          ),
                          activeIcon:Image.asset(
                            'assets/images/course_select.png',
                            width: 25,
                            height: 27.5,
                            fit: BoxFit.cover,
                          ),
                          label: '课程',
                      ),
                      BottomNavigationBarItem(
                        icon: Image.asset(
                          'assets/images/library.png',
                          width: 25,
                          height: 27.5,
                          fit: BoxFit.cover,
                        ),
                        activeIcon:Image.asset(
                          'assets/images/library_select.png',
                          width: 25,
                          height: 27.5,
                          fit: BoxFit.cover,
                        ),
                        label: '图书馆',
                      ),
                      BottomNavigationBarItem(
                        icon: Image.asset(
                          'assets/images/shujia.png',
                          width: 25,
                          height: 27.5,
                          fit: BoxFit.cover,
                        ),
                        activeIcon:Image.asset(
                          'assets/images/shujia_select.png',
                          width: 25,
                          height: 27.5,
                          fit: BoxFit.cover,
                        ),
                        label: '书架',
                      ),
                      BottomNavigationBarItem(
                        icon: Image.asset(
                          'assets/images/mine.png',
                          width: 25,
                          height: 27.5,
                          fit: BoxFit.cover,
                        ),
                        activeIcon:Image.asset(
                          'assets/images/mine_select.png',
                          width: 25,
                          height: 27.5,
                          fit: BoxFit.cover,
                        ),
                        label: '我的',
                      )
                  ]
              ),
            ),
          ),
        )
    );
  }
}
