part of user_discuss;

class BuildItem extends StatelessWidget {
  final CourseModel model;
  final int index;
  final int num;
  const BuildItem({
    Key? key,
    required this.model,
    required this.index,
    required this.num
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
      // margin: const EdgeInsets.symmetric(horizontal: 10),
      padding: EdgeInsets.symmetric(horizontal: 10.w),
      margin: const EdgeInsets.all(10),
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(8),
        color: Colors.white,
        boxShadow: [
          BoxShadow(
            color: const Color(0xFFC7C7C7).withOpacity(0.5),
            offset: Offset(3.w, 0),
            blurRadius: 10.w,
            spreadRadius: 0.w,
          ),
        ],
      ),
      child: Column(
        children: [
          Container(
            padding:  EdgeInsets.only(top: 12.w,bottom: 15.w),
            // color: Colors.red,
            child: Row(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                CustomCard(
                  width: 72.w,
                  height: 86.w,
                  url: model.img??'',
                ),
                Expanded(
                  child: Container(
                    height: 87.w,
                    margin: EdgeInsets.only(left: 13.w),
                    // color: Colors.green,
                    child: Column(
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            Text(model.bookName??'',style: TextStyle(fontSize: 14.w,height: 1.5,fontWeight: Fonts.medium,color: Colours.c3),),
                            Text(model.authors??'',style:  TextStyle(fontSize: 12.w,height: 1.5,color: Colours.c6),overflow: TextOverflow.ellipsis,maxLines: 2,),
                          ],
                        ),
                        Text('${model.commentNum.toString()}个讨论',style: TextStyle(fontSize: 11.w,height: 1.5,color: AppTheme.primary)),
                      ],
                    ),
                  ),
                )
              ],
            ),
          )
        ],
      ),
    );
  }
}
