part of user_love;

class BuildItem extends StatelessWidget {
  final CourseModel model;
  final void Function()? onTap;
  const BuildItem({
    Key? key,
    required this.model,
    this.onTap
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
      padding:  EdgeInsets.only(left: 10.w,top: 15.w,bottom: 15.w),
      margin:  EdgeInsets.only(top:15.w,left: 10.w,right: 10.w),
      decoration: BoxDecoration(
        color: Colors.white,
        borderRadius: BorderRadius.circular(8.w),
        boxShadow: [
          BoxShadow(
            color: Colours.cC7.withOpacity(0.5), // 阴影颜色
            spreadRadius: 2.w, // 阴影扩散半径
            blurRadius: 5.w, // 阴影模糊半径
            offset: Offset(0, 2.w), // 阴影偏移
          ),
        ],

      ),
      // height: 200,
      // color: Colors.cyanAccent,
      child: Row(
        children: [
          /// 左侧
          CustomCard(
            width: 72.w,
            height: 86.w,
            url: model.img??'',
          ),
          /// 右侧
          Expanded(
            child: Container(
              margin: EdgeInsets.only(left: 10.w,right: 10.w),
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Text(model.bookName??'',overflow: TextOverflow.ellipsis,maxLines: 1,style: TextStyle(fontSize: 14.w,fontWeight: Fonts.medium,height: 1.5,color: Colours.c3),),
                  SizedBox(height: 4.w,),
                  Text(model.authors??'',style:  TextStyle(fontSize: 12.w,color: Colours.c9,height: 1.5),),
                  Gaps.vGaps15,
                  Row(
                    mainAxisAlignment: MainAxisAlignment.spaceBetween,
                    crossAxisAlignment: CrossAxisAlignment.center,
                    children: [
                      const SizedBox(),
                      GestureDetector(
                        onTap: onTap,
                        child: Container(
                          padding: EdgeInsets.only(top: 10.w),
                          width: 30.w,
                          height: 30.w,
                          // color: Colors.yellow,
                          child: Image.asset(
                            'assets/images/del.png',
                          ),
                        ),
                      )
                    ],
                  )
                ],
              ),
            ),
          )
        ],
      ),
    );
  }
}
