part of apis;


abstract class LibraryAPI {

  /// 1、图书分类
  ///
  static Future <List<CategoryModel>> categories() async {
    final result = await HttpService.to.post(
      '/v1/book/category/getCategoryListAll',
      params: {},
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index){
      return CategoryModel.fromJson(result.data['list'][index]);
    });
  }

  /// 2、图书标签
  ///
  static Future <List<LabelModel>> labels() async {
    final result = await HttpService.to.post(
      '/v1/book/category/getLabelListAll',
      params: {},
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index){
      return LabelModel.fromJson(result.data['list'][index]);
    });
  }

  /// 3、书籍列表
  ///
  static Future <List<CourseModel>> books({
    int page = 1,
    int limit = 10,
    String sortField = '',
    String sort = '',
    String isFree = '',
    String labelId = '',
    required String categoryId
  }) async {
    Map<String,dynamic> params = {
      'page' : page,
      'limit' : limit,
      'category_id':categoryId
    };
    if (sortField.isNotEmpty){
      params['sort_field'] = sortField;
    }
    if (sort.isNotEmpty){
      params['sort'] = sort;
    }
    if (isFree.isNotEmpty){
      params['is_free'] = isFree;
    }
    if (sort.isNotEmpty){
      params['sort'] = sort;
    }
    if (labelId.isNotEmpty){
      params['label_id'] = labelId;
    }


    final result = await HttpService.to.post(
      '/v1/book/category/getBookList',
      params: params,
      showLoading: true
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index){
      return CourseModel.fromJson(result.data['list'][index]);
    });
  }

  /// 4、评分及书评
  ///
  static Future <List<ScoreModel>> scores({
    int page = 1,
    int limit = 10,
    required String bookId
  }) async {
    final result = await HttpService.to.post(
      '/v1/book/Information/getBookCommentList',
      params: {
        'page': page,
        'page_size': limit,
        'book_id':bookId
      },
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index){
      return ScoreModel.fromJson(result.data['list'][index]);
    });
  }

  /// 5、获取书籍目录
  ///
  static Future <List<ChapterModel>> chapters({
    required String bookId
  }) async {
    final result = await HttpService.to.post(
      '/v1/book/Information/getBookChapter',
      params: {
        'book_id':bookId
      },
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index){
      return ChapterModel.fromJson(result.data['list'][index]);
    });
  }

  /// 6、获取书籍详情
  ///
  static Future <BookDetailModel> details({
    required String bookId
  }) async {
    final result = await HttpService.to.post(
      '/v1/book/Information/getBookInformation',
      params: {
        'book_id':bookId
      },
    );
    if (result.data is! Map) return BookDetailModel();
    return BookDetailModel.fromJson(result.data);
  }

  /// 6、学习报告
  ///
  static Future <ReportModel> report({
    required String bookId
  }) async {
    final result = await HttpService.to.post(
      '/v1/members/Information/myStudyReport',
      params: {
        'book_id':bookId
      },
    );
    if (result.data is! Map) return ReportModel();
    return ReportModel.fromJson(result.data);
  }

  /// 7、阅读页的笔记列表
  ///
  static Future<List<NoteModel>> noteList(
      {int page = 1,
        int limit = 10,
        required String bookId,
        required String chapterId}) async {
    final result = await HttpService.to.post(
      '/v1/book/Information/getChapterNotesList',
      params: {
        'page': page,
        'page_size': limit,
        'book_id': bookId,
        'chapter_id': chapterId
      },
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index) {
      return NoteModel.fromJson(result.data['list'][index]);
    });
  }

  /// 8、笔记详情列表
  ///
  static Future<List<DiscussModel>> discussList(
      {int page = 1,
        int limit = 10,
        required String bookId,
        required String chapterId}) async {
    final result = await HttpService.to.post(
      '/v1/book/Information/getChapterCommentList',
      params: {
        'page': page,
        'page_size': limit,
        'book_id': bookId,
        'chapter_id': chapterId
      },
    );
    if (result.data is! Map && result.data['list'] is! List) return [];
    return List.generate(result.data['list'].length, (index) {
      return DiscussModel.fromJson(result.data['list'][index]);
    });
  }


}