part of course;


class CourseController extends GetxController {

  late final List<String> courses;

  final EasyRefreshController refreshController = EasyRefreshController(
    controlFinishLoad: true,
    controlFinishRefresh: true,
  );

  final int _limit = 20;
  int _page = 1;
  bool _noMore = false;


  @override
  void onClose() {
    refreshController.dispose();
    super.onClose();
  }

  Future<void> _getCourse([bool isRefresh = false]) async {
    if (isRefresh) _page = 1;
    /// 网路请求
    List result = [];
    /// 如果是刷新 清理数据
    if (isRefresh) courses.clear();
    courses.addAll([]);
    _page ++;
    _noMore = result.length < _limit;
    update();

  }

  void onRefresh() async {
    try {
      await _getCourse(true);
      refreshController.finishRefresh(IndicatorResult.success);
      refreshController.resetFooter();
    } catch (error) {
      refreshController.finishRefresh(IndicatorResult.fail);
    }
  }

  void onLoading() async {
    if (_noMore) {
      refreshController.finishLoad(IndicatorResult.noMore);
    }
    try {
      await _getCourse();
      refreshController.finishLoad();
    } catch (error) {
      refreshController.finishLoad(IndicatorResult.fail);
    }
  }

}