part of models;

class ReadModel {

  ReadModel({
    required this.value,
    required this.name,
    this.link,
    this.icon
  });

  String value;
  String name;
  String? link;
  String? icon;
}


/// 紫金币 积分  模型
///
class RecordModel {
  RecordModel({
    this.integralId,
    this.options,
    this.numbers,
    this.result,
    this.remarks,
    this.createTime,});

  RecordModel.fromJson(dynamic json) {
    integralId = json['integral_id'];
    options = json['options'];
    numbers = json['numbers'];
    result = json['result'];
    remarks = json['remarks'];
    createTime = json['create_time'];
  }
  num? integralId;
  num? options;
  num? numbers;
  num? result;
  String? remarks;
  String? createTime;
  RecordModel copyWith({  num? integralId,
    num? options,
    num? numbers,
    num? result,
    String? remarks,
    String? createTime,
  }) => RecordModel(  integralId: integralId ?? this.integralId,
    options: options ?? this.options,
    numbers: numbers ?? this.numbers,
    result: result ?? this.result,
    remarks: remarks ?? this.remarks,
    createTime: createTime ?? this.createTime,
  );
  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['integral_id'] = integralId;
    map['options'] = options;
    map['numbers'] = numbers;
    map['result'] = result;
    map['remarks'] = remarks;
    map['create_time'] = createTime;
    return map;
  }

}

/// 优惠券模型
///
class CouponModel {
  CouponModel({
    this.couponRecId,
    this.endTime,
    this.couponId,
    this.useStatus,
    this.couponName,
    this.normPrice,
    this.reducedPrice,});

  CouponModel.fromJson(dynamic json) {
    couponRecId = json['coupon_rec_id'];
    endTime = json['end_time'];
    couponId = json['coupon_id'];
    useStatus = json['use_status'];
    couponName = json['coupon_name'];
    normPrice = json['norm_price'];
    reducedPrice = json['reduced_price'];
  }
  num? couponRecId;
  String? endTime;
  num? couponId;
  num? useStatus;
  String? couponName;
  num? normPrice;
  String? reducedPrice;
  CouponModel copyWith({  num? couponRecId,
    String? endTime,
    num? couponId,
    num? useStatus,
    String? couponName,
    num? normPrice,
    String? reducedPrice,
  }) => CouponModel(  couponRecId: couponRecId ?? this.couponRecId,
    endTime: endTime ?? this.endTime,
    couponId: couponId ?? this.couponId,
    useStatus: useStatus ?? this.useStatus,
    couponName: couponName ?? this.couponName,
    normPrice: normPrice ?? this.normPrice,
    reducedPrice: reducedPrice ?? this.reducedPrice,
  );
  Map<String, dynamic> toJson() {
    final map = <String, dynamic>{};
    map['coupon_rec_id'] = couponRecId;
    map['end_time'] = endTime;
    map['coupon_id'] = couponId;
    map['use_status'] = useStatus;
    map['coupon_name'] = couponName;
    map['norm_price'] = normPrice;
    map['reduced_price'] = reducedPrice;
    return map;
  }

}