part of user_msg;

class BuildItem extends StatelessWidget {
  final MsgModel model;
  const BuildItem({
    Key? key,
    required this.model
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: const EdgeInsets.only(left: 10,right: 10,top:10),
      padding: const EdgeInsets.symmetric(horizontal: 10,vertical: 10),
      height: 75,
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(8),
        color: Colors.white
      ),
      child: Row(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          badges.Badge(
            showBadge: model.status == 1?false: true,
            position: badges.BadgePosition.topEnd(top: 0, end: 0),
            badgeStyle: const badges.BadgeStyle(
                badgeColor: AppTheme.primary,
                shape: badges.BadgeShape.circle
            ),
            child: Container(
              width: 30,
              height: 30,
              decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(15),
                  color: AppTheme.primary.withOpacity(0.1)
              ),
              child: Image.asset(
                'assets/images/msg.png',
              ),
            ),
          ),
          Gaps.hGaps10,
          Expanded(
            child: Column(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                Row(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  children: [
                    Text(model.title??'',style: const TextStyle(fontSize: 15,height: 1.4,fontWeight: Fonts.medium,color: Colours.c3),),
                    Text(model.createTime??'',style: const TextStyle(fontSize:11,height: 1.4,color: Colours.c9))
                  ],
                ),
                Gaps.vGaps5,
                Text(model.content??'',style: const TextStyle(fontSize: 13,height: 1.4,color: Colours.c6),)
              ],
            ),
          )
        ],
      ),
    );
  }
}
