part of login;


enum LoginType{code, password}

class LoginController extends GetxController {

  // 0：密码登录  1：验证码登录
  late int loginType = 0;
  // 2、密码登录
  // 账号
  final TextEditingController phoneInput = TextEditingController();
  // 密码
  final TextEditingController passwordInput = TextEditingController();
  // 验证码
  final TextEditingController codeInput = TextEditingController();
  // 显示密码
  final ValueNotifier<bool> showPassword = ValueNotifier(false);
  // 定时器
  late Timer _timer;

  // 按钮是否可用
  bool  _enable = false;
  bool get enable => _enable;

  // 倒计时60秒
  int _countDown = 60;
  int get countDown => _countDown;
  bool _isCounting = false;
  bool get isCounting => _isCounting;

  // 同意协议
  bool _agree = false;
  bool get agree => _agree;
  void setAgree() {
    _agree = !_agree;
    update();
  }

  // 开启定时器
  void start() {
    _isCounting = true;
    _timer = Timer.periodic(const Duration(seconds: 1), (timer) {
      if (_countDown > 1) {
        _countDown--;
      } else {
        stop();
      }
      update();
    });
  }

  // 停止计时器
  void stop() {
    if (_timer != null){
      _timer.cancel();
      _isCounting = false;
    }
    _countDown = 60;
  }

  void setCanClick(){
    if (loginType == 0){
      if (ValidatorTool.isValidPhoneNumber(phoneInput.text) && ValidatorTool.isValidPassword(passwordInput.text)){
        _enable = true;
      }
      else{
        _enable = false;
      }
    }
    else {
      if (ValidatorTool.isValidPhoneNumber(phoneInput.text) && ValidatorTool.isValidCode(codeInput.text)){
        _enable = true;
      }
      else{
        _enable = false;
      }
    }

    update();
  }


  @override
  void onInit() {
    _timer = Timer.periodic(const Duration(seconds: 1), (timer) {
      // 定时器回调
    });
    /// 测试账号
    if (kDebugMode) {
       phoneInput.text = '13521054068';
        passwordInput.text = 'zj123456';
       // phoneInput.text = '17311837355';
       // passwordInput.text = '12345678';
    }
    super.onInit();
  }

  @override
  void onClose() {
    phoneInput.dispose();
    passwordInput.dispose();
    showPassword.dispose();
    codeInput.dispose();
    _timer.cancel();
    _isCounting = false;
    super.onClose();
  }

  void onShowPassword() => showPassword.value = !showPassword.value;

  void updateLoginType(int value){
    stop();
    loginType = value;
    update();
  }

  /// 登录
  void onLogin(BuildContext context) async {
    if (!agree) {
      Toast.show('请先阅读并同意《用户协议》和《隐私政策》');
      return;
    }

    String type = '1';
    if (loginType == 1) {
      type = '2';
    }
    final result = await AccountAPI.login(
        phone: phoneInput.text,
        password: EncryptUtil.encodeMd5(EncryptUtil.encodeMd5(passwordInput.text)),
        code: codeInput.text,
        type: type
    );

    if((result.token ?? '').isEmpty) return;


    // 存储用户信息
    await Future.wait([
       UserStore.to.setToken(result.token!),
       UserStore.to.setAccessToken(result.accessToken!),
    ]);

    await Future.wait([
      UserStore.to.setInfo(result),
      UserStore.to.profile(),
    ]);

    if (!context.mounted) return;
    if (context.canPop()){
      context.pop();
    }else {
      context.goNamed(Routes.main);
    }

  }

  void sendCode() async {
    if (!agree) {
      Toast.show('请先阅读并同意《用户协议》和《隐私政策》');
      return;
    }
    final result = await AccountAPI.sendCode(phone: phoneInput.text, type: 'login');
    if (result){
      Toast.show('发送成功');
      start();
    }
    else{
      Toast.show('发送失败');
    }

  }

}