part of user_wrong;

class UserWrongPage extends StatefulWidget {
  const UserWrongPage({Key? key}) : super(key: key);

  @override
  State<UserWrongPage> createState() => _UserWrongPageState();
}

class _UserWrongPageState extends State<UserWrongPage> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<UserWrongController>(
      init: UserWrongController(),
      builder:(controller)=> Scaffold(
        appBar: AppBar(
          centerTitle: true,
          title: const Text('错题'),
        ),
        body: CustomPullScrollView(
            controller: controller.refreshController,
            onRefresh: controller.onRefresh,
            onLoading: controller.onLoading,
            child:SingleChildScrollView(
              child: Container(
                margin: const EdgeInsets.all(10),
                decoration: BoxDecoration(
                  borderRadius: BorderRadius.circular(8),
                  color: Colors.white,
                  boxShadow: [
                    BoxShadow(
                      color: const Color(0xFFC7C7C7).withOpacity(0.5),
                      offset: const Offset(3, 0),
                      blurRadius: 10.w,
                      spreadRadius: 0.w,
                    ),
                  ],
                ),
                child: ListView.builder(
                  physics: const NeverScrollableScrollPhysics(),
                  shrinkWrap: true,
                  itemBuilder: (BuildContext context, int index){
                    return BuildItem(model: controller.wrongs[index],index: index,num: controller.wrongs.length,);
                  },
                  itemCount: controller.wrongs.length,
                ),
              ),
            )
        ),
      ),
    );
  }
}
