part of study_history;

class BuildDayItem extends StatelessWidget {
  const BuildDayItem({Key? key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
      // height: 300,
      margin: EdgeInsets.only(left: 10,top: 10,right: 10),
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(8),
        boxShadow:  [
          BoxShadow(
            color: Colours.cC7.withOpacity(0.5),
            offset: const Offset(1, 3),
            blurRadius: 10,
            spreadRadius: 0,
          ),
        ],
        color: Colors.white
      ),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Container(
            height: 32,
            color: Colors.cyan,
            alignment: Alignment.centerLeft,
            child: Text('今天',style: TextStyle(fontSize: 13,height: 1.4,color: Colours.c6),),
          ),
          ListView.builder(
            shrinkWrap: true,
            physics: NeverScrollableScrollPhysics(),
            itemBuilder:(BuildContext context, int index){
              return _buildItem();
            },
            itemCount: 2,
          )
        ],
      ),
    );
  }

  Widget _buildItem(){
    return Container(
      margin: EdgeInsets.only(left: 10,right: 10),
      child: Column(
        children: [
          Container(
            color: Colours.cF0,
            height: 2,
          ),
          Container(
            margin: EdgeInsets.only(top: 11.5,bottom: 14.5),
            child: Row(
              children: [
                Container(
                  width: 72,
                  height: 87,
                  color: Colors.red,
                ),
                Column(
                  children: [
                    Text('从现在开始，为精彩活过一百',style: TextStyle(fontSize: 14,height: 1.5,fontWeight: Fonts.medium,color: Colours.c3),maxLines: 1,overflow: TextOverflow.ellipsis,),
                    Text('李白',style: TextStyle(fontSize: 12,height: 1.4,color: Colours.c6),),
                    Row(
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      children: [
                        Container(
                          color: Colors.cyan,
                          padding: const EdgeInsets.symmetric(horizontal: 3.5),
                          child: const Text('未学习',style: TextStyle(fontSize: 11,height: 1.3,color: Colours.c9),),
                        ),
                        const Text('继续学习',style: TextStyle(fontSize: 11,height: 1.3,color: AppTheme.primary),)
                      ],
                    )
                  ],
                )
              ],
            ),
          )
        ],
      ),
    );
  }
}
