part of web;

class ReadDiscussPage extends StatefulWidget {
  final void Function()? onTap;
  final BookDetailModel bookDetailModel;
  // 当前的章节id
  final String chapterId;
  const ReadDiscussPage({
    Key? key,
    required this.onTap,
    required this.bookDetailModel,
    required this.chapterId
  }) : super(key: key);

  @override
  State<ReadDiscussPage> createState() => _ReadDiscussPageState();
}

class _ReadDiscussPageState extends State<ReadDiscussPage> {
  late TextEditingController searchController = TextEditingController();
  @override
  Widget build(BuildContext context) {
    return GetBuilder<DiscussController>(
      init: DiscussController(bookDetailModel: widget.bookDetailModel,chapterId: widget.chapterId),
      builder:(controller) => Scaffold(
        resizeToAvoidBottomInset: false,
        body: Column(
          crossAxisAlignment: CrossAxisAlignment.end,
          children: [
            Container(
                margin: EdgeInsets.only(left: 15.w,right: 15.w,top: 15.w,bottom: 15.w),
                child: GestureDetector(
                  onTap: widget.onTap,
                  child: Image.asset('assets/images/close.png')
                )
            ),
            Container(
              margin: EdgeInsets.only(left: 15.w,right: 15.w,),
              decoration: BoxDecoration(
                color: const Color(0xFFF9F9F9),
                borderRadius: BorderRadius.circular(17.5.w),
                boxShadow: [
                  BoxShadow(
                    color: const Color(0xFFC7C7C7).withOpacity(0.5),
                    offset: Offset(3.w, 0),
                    blurRadius: 10.w,
                    spreadRadius: 0.w,
                  ),
                ],
              ),
              child: ClipRRect(
                borderRadius: BorderRadius.circular(17.5.w),
                child: CustomInputSearch(
                  controller: searchController,
                  readOnly: false,
                  hintText: '请输入书籍名称讨论',
                  onTap: () {
                    // context.pushNamed(Routes.msgs);
                  },
                  onEditingComplete: () {

                  },
                ),
              ),
            ),
            BuildBook(bookDetailModel: widget.bookDetailModel,),
            Expanded(
              child: ListView.builder(
                itemBuilder: (BuildContext context,int index){
                  DiscussModel model = controller.discuss[index];
                  return BuildDiscuss(model: model,);
                },
                itemCount: controller.discuss.length,
              ),
            )

          ],
        ),
      ),
    );
  }
}
