part of user_notes_des;

class BuildListPage extends StatefulWidget {
  final String tag;
  final CourseModel model;
  const BuildListPage({
    Key? key,
    required this.tag,
    required this.model
  }) : super(key: key);


  @override
  State<BuildListPage> createState() => _BuildListPageState();
}

class _BuildListPageState extends State<BuildListPage> with AutomaticKeepAliveClientMixin{
  @override
  Widget build(BuildContext context) {
    return GetBuilder<UserNotesDesController>(
      tag: widget.tag,
      init: UserNotesDesController(widget.tag,widget.model),
      builder: (controller) =>CustomPullScrollView(
        controller: controller.refreshController,
        onLoading: controller.onLoading,
        child: ListView.builder(
            itemBuilder: (BuildContext context,int index){
              NoteModel model = controller.notes[index];
              // 划线
              if(model.types == 1){
                return  GestureDetector(
                  // TODO:跳转阅读页对应位置
                  onTap: () async{
                    final result = await context.pushNamed(Routes.web,queryParameters: {'book_id': widget.model.bookId.toString(),'chapter_id': model.chapterId.toString(),'chapter_name':model.chapterName.toString(),'note_id':model.notesId.toString()},extra: BookDetailModel(bookId: widget.model.bookId));
                  },
                  child: BuildLine(model: model,
                    onTapDel: (){
                      controller.delNotes(notesId: model.notesId.toString(), bookId:widget.model.bookId.toString());
                    },
                  ),
                );
              }
              // 高亮
              else if(model.types == 2){
                return GestureDetector(
                  // TODO:跳转阅读页对应位置
                  onTap: () async{
                    final result = await context.pushNamed(Routes.web,queryParameters: {'book_id': widget.model.bookId.toString(),'chapter_id': model.chapterId.toString(),'chapter_name':model.chapterName.toString(),'note_id':model.notesId.toString()},extra: BookDetailModel(bookId: widget.model.bookId));
                  },
                  child: BuildHigh(model: model,
                    onTapDel: (){
                      controller.delNotes(notesId: model.notesId.toString(), bookId:widget.model.bookId.toString());
                    },
                  ),
                );
              }
              // 笔记
              else if(model.types == 3){
                return BuildNote(model: model,
                  onTapDel: (){
                    controller.delNotes(notesId: model.notesId.toString(), bookId:widget.model.bookId.toString());
                  },
                  onTapEdit: (){
                    context.pushNamed(Routes.editNote,extra: model,queryParameters: {'book_id':widget.model.bookId.toString()});
                  },
                  onTapAudio: (mediaModel){
                    controller.playAudio(mediaModel);
                  },
                );
              }
              return null;
            },
          itemCount: controller.notes.length,
        ),
      ),
    );
  }

  @override
  bool get wantKeepAlive => true;
}
