part of book_detail;



class BookDetailPage extends StatefulWidget {
  final String bookId;
  const BookDetailPage({
    Key? key,
    required this.bookId
  }) : super(key: key);

  @override
  State<BookDetailPage> createState() => _BookDetailPageState();
}

class _BookDetailPageState extends State<BookDetailPage> with SingleTickerProviderStateMixin{


  @override
  Widget build(BuildContext context) {
    return GetBuilder<BookDetailController>(
      init:BookDetailController(widget.bookId),
      builder: (controller)=> Scaffold(
        appBar:  CustomAppBar(
          backgroundColor: const Color(0xFFAB1941).withOpacity(0.02),
          title: const Text('详情',style: TextStyle(fontSize: 17),),
          actions: [
            CustomButton.icon(
              padding: EdgeInsets.zero,
              backgroundColor: Colors.transparent,
              icon: Image.asset('assets/images/shop.png'),
              onPressed: () => context.pushNamed(Routes.shop),
            ),
            CustomButton.icon(
              padding: EdgeInsets.zero,
              backgroundColor: Colors.transparent,
              icon: Image.asset(
                controller.bookDetails.isCollection == 0? 'assets/images/unlove.png':'assets/images/love.png',
              ),
              onPressed: () {
                controller.love(bookId: controller.bookDetails.bookId.toString(), isCollection: controller.bookDetails.isCollection!);
              },
            ),
          ],
        ),
        body:
        Column(
          children: [
            BuildBook(model: controller.bookDetails,),
            Container(
              height: 10.w,
              color: const Color(0xFFF9F9F9),
            ),
            BuildStudy(model:controller.bookDetails,),
            Container(
              height: 2,
              color: const Color(0xFFF9F9F9),
            ),
            Container(
              color: Colors.white,
              child: TabBar(
                labelColor: AppTheme.primary,
                // isScrollable: true,
                labelStyle: TextStyle(fontSize: 15.w,height: 1.4,fontWeight: Fonts.boldSemi),
                unselectedLabelColor: Colours.c9,
                unselectedLabelStyle: TextStyle(fontSize: 15.w,height: 1.4),
                indicatorSize: TabBarIndicatorSize.label,
                indicatorColor: AppTheme.primary,
                tabs:controller.tabs,
                physics: const NeverScrollableScrollPhysics(),
                controller: controller.tabController,
              ),
            ),
            Container(
              height: 1.w,
              color: const Color(0xFFF9F9F9),
            ),
            Container(
              height: 8.w,
              color: Colors.transparent,
            ),
            Expanded(
              child: TabBarView(
                controller: controller.tabController,
                physics: const NeverScrollableScrollPhysics(),
                children: [
                  BookCategoryPage(
                    chapters: controller.chapters,
                    bookId: controller.bookId,
                    bookDetails: controller.bookDetails,
                    onTap: (ChapterModel chapterModel) async{
                      if(controller.bookDetails.isFree == 0  && controller.bookDetails.isHave ==0 && chapterModel.isReading ==0){
                        List<CourseModel> buy = [];
                        CourseModel model= CourseModel(
                            bookId: controller.bookDetails.bookId,
                            price: controller.bookDetails.price,
                            vipPrice: controller.bookDetails.vipPrice,
                            img: controller.bookDetails.img,
                            bookName: controller.bookDetails.bookName,
                            cartId: 0,
                            status: 1,
                            selected: true
                        );
                        buy.add(model);

                       context.pushNamed(Routes.bookPay,extra: buy).then((value) {
                         controller.getBookDetails();
                       });

                      }else{
                        pushToReadPage(controller: controller, chapterName: chapterModel.name.toString(), chapterId: chapterModel.id.toString());
                      }
                    },
                  ),
                  SingleChildScrollView(
                    child: Container(
                      padding: EdgeInsets.only(left: 15.w,right: 15.w,top:12.w),
                      color: Colors.white,
                      child: Text(controller.bookDetails.introduction??'',style: const TextStyle(fontSize: 15,height: 2.1,color: Colours.c9),),
                    ),
                  ),
                  InAppWebView(
                    contextMenu: ContextMenu(
                      options: ContextMenuOptions(hideDefaultSystemContextMenuItems: true),
                    ),
                    onWebViewCreated: (InAppWebViewController wcontroller){

                      wcontroller.loadData(data: """
                      <!DOCTYPE html>
                      <html lang="zh-CN">
                      <head>
                      <meta charset="utf-8" />
                      <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
                      <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no" />
                      <meta http-equiv="Cache-Control" content="no-transform" />
                      <meta http-equiv="Cache-Control" content="no-siteapp" />
                      <style>
                           *{ margin: 0px; padding: 5px; font-size:16px}
                           html{ font-size: 10px;}
                           body{ padding:0px;color: #999}
                           body p{ font-size: 1.5rem; line-height:2.4rem;color: #999}
                           img,video,pre,code{ max-width:100%}
                           pre{white-space: pre-wrap;word-wrap: break-word;word-break: break-all}
                           hr{background-color: var(--w-e-textarea-border-color); border: 0; display: block; height: 1px}
                           table, td {border: 1px solid #ccc;border-collapse: collapse;}
                           ol, ol li{margin:10px}
                           ul, ul li{margin:10px}
                      </style>
                      </head>
                      <body>
                          ${controller.bookDetails.content}
                      </body>
                      </html>
                      """,);
                    },
                  ),
                  BookInfoPage(model:controller.bookDetails,)
                ],
              ),
            ),

          ],
        ),
        bottomNavigationBar: SafeArea(
          child: Container(
            color: Colors.white,
            padding: EdgeInsets.symmetric(horizontal: 15.w,vertical: 10.w),
            child: Row(
              mainAxisAlignment: MainAxisAlignment.spaceEvenly,
              children: [
                Expanded(
                  child: GestureDetector(
                    onTap: (){
                      if(controller.bookDetails.isHave ==1 || controller.bookDetails.isFree == 1){
                        context.pushNamed(Routes.studyReport,queryParameters: {'book_id':widget.bookId});
                      }
                      else{
                        controller.addCart(widget.bookId);
                      }
                    },
                    child: Container(
                      alignment: Alignment.center,
                      height: 35,
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(17.5.w),
                        border:Border.all(
                          width: 0.5,
                          color: Colours.c9
                        ),
                        // color: Colours.cE0.withOpacity(0.5),
                      ),
                      // padding: EdgeInsets.symmetric(vertical: 8),
                      child: controller.bookDetails.isHave ==1 || controller.bookDetails.isFree == 1? Text('学习报告',style: TextStyle(fontSize: 13.w,color: Colours.c9,height: 1.5),):Text('加入书架',style: TextStyle(fontSize: 13.w,color: AppTheme.primary,height: 1.5),),
                    ),
                  ),
                ),
                Gaps.hGaps10,
                Expanded(
                  child: GestureDetector(
                    onTap: () async{

                      // 1免费 0 不免费
                      if(controller.bookDetails.isFree == 1){
                        final String chapterId = await controller.getCurrentChapterId();
                        final String chapterName = await controller.getCurrentChapterName();
                        pushToReadPage(controller: controller, chapterName: chapterName, chapterId: chapterId);
                      }
                      else {
                        // 没有购买
                        if (controller.bookDetails.isHave ==0){
                           // 没有试读
                           if (controller.bookDetails.readChapterId ==0){
                             List<CourseModel> buy = [];
                             CourseModel model= CourseModel(
                                 bookId: controller.bookDetails.bookId,
                                 price: controller.bookDetails.price,
                                 vipPrice: controller.bookDetails.vipPrice,
                                 img: controller.bookDetails.img,
                                 bookName: controller.bookDetails.bookName,
                                 cartId: 0,
                                 status: 1,
                                 selected: true
                             );
                             buy.add(model);

                            context.pushNamed(Routes.bookPay,extra: buy).then((value){
                              controller.getBookDetails();
                            });

                           }
                           else{
                             final String chapterId = await controller.getCurrentChapterId();
                             final String chapterName = await controller.getCurrentChapterName();
                             pushToReadPage(controller: controller, chapterName: chapterName, chapterId: chapterId);
                           }
                        }
                        else{

                          final String chapterId = await controller.getCurrentChapterId();
                          final String chapterName = await controller.getCurrentChapterName();
                          pushToReadPage(controller: controller, chapterName: chapterName, chapterId: chapterId);

                        }
                      }
                    },
                    child: Container(
                      decoration: BoxDecoration(
                        borderRadius: BorderRadius.circular(17.5.w),
                        color: AppTheme.primary.withOpacity(0.1)
                      ),
                      height: 35.w,
                      alignment: Alignment.center,
                      padding:  EdgeInsets.symmetric(vertical: 8.w),
                      child:  Text('阅读',style: TextStyle(fontSize: 13.w,color: AppTheme.primary,height: 1.5,fontWeight: Fonts.boldSemi),),
                    ),
                  ),
                )
              ],
            ),
          ),
        ),
      ),
    );

  }

  void pushToReadPage({
    required BookDetailController controller,
    required String chapterName,
    required String chapterId,
  }) async{
    final PopBackModel? backModel = await context.pushNamed(Routes.web,queryParameters: {'book_id': controller.bookDetails.bookId.toString(),'chapter_id': chapterId,'chapter_name':chapterName,'note_id':'0'},extra: controller.bookDetails);
    if (backModel!.back == true){
      controller.getChapters();
      controller.currentChapterId = int.parse(backModel!.chapterId);
      controller.getBookDetails();
      // controller.setCurrentReadChapterId(backModel!.chapterId);
    }
  }

}
