part of user_order;

/// 等待付款订单
class UserOrderController extends GetxController with GetTickerProviderStateMixin{
  final String tag;
  // final List<OrderListModel> models;
  UserOrderController(this.tag);
  List<OrderListModel> orderList = [];

  final EasyRefreshController refreshController = EasyRefreshController(
    controlFinishLoad: true,
    controlFinishRefresh: true,
  );

  late TextEditingController searchController = TextEditingController();

  final int _limit = 10;
  int _page = 1;
  bool _noMore = false;


  @override
  void onReady() {
    onRefresh();
    super.onReady();
  }

  @override
  void onClose() {
    searchController.dispose();
    refreshController.dispose();
    super.onClose();
  }

  /// 搜索书籍
  void search() async {
    // books = await CommonAPI.searchBooks(keyWord: searchController.text);
    // _getSearchRecords();
    update();
  }




  /// 获取订单列表
  Future<void> _getOrders([bool isRefresh = false]) async {
    if (isRefresh) _page = 1;
    // 网路请求
    final result = await MineAPI.orderList(
        page: _page,
        limit: _limit,
        status: int.parse(tag),
    );
    // 如果是刷新 清理数据
    if (isRefresh) orderList.clear();
    orderList.addAll(result);
    _page ++;
    _noMore = result.length < _limit;
    // addData();
    update();
  }

  void onRefresh() async {
    try {
      await _getOrders(true);
      refreshController.finishRefresh(IndicatorResult.success);
      refreshController.resetFooter();
    } catch (error) {
      refreshController.finishRefresh(IndicatorResult.fail);
    }
  }

  void onLoading() async {
    if (_noMore) {
      refreshController.finishLoad(IndicatorResult.noMore);
      return;
    }
    try {
      await _getOrders();
      refreshController.finishLoad();
    } catch (error) {
      refreshController.finishLoad(IndicatorResult.fail);
    }
  }

  void addData(){
    orderList.add(OrderListModel(id:1,ordersnum: "ewrewr",totalPrice: "78.12",finalTotalPrice:'56',status: 1,payType: 1,types: 1,createTime: "2024-01-11 11:11:50",
        cartList: [CartListModel(recordId: 876,orderId: 712,price: "78.12",bookId: 110,name: "老人与海",img:"http://zxts-user-file.oss-cn-beijing.aliyuncs.com/2024-01/20/eb167c2f59f7e34c0ef94a9f1ce736ee64d76a11.jpg",
            introduction: "1一想到还有9",rating: 4.5,comments: "好好好",commentId: '2'),]));
    orderList.add(OrderListModel(id:1,ordersnum: "gdfaf",totalPrice: "78.12",finalTotalPrice:'67',status: 1,payType: 1,types: 1,createTime: "2024-01-11 11:11:50",
        cartList: [CartListModel(recordId: 876,orderId: 712,price: "78.12",bookId: 110,name: "老人与海",img:"http://zxts-user-file.oss-cn-beijing.aliyuncs.com/2024-01/20/eb167c2f59f7e34c0ef94a9f1ce736ee64d76a11.jpg",
            introduction: "一想到还有95%的问题留给人类，我就放一想到还有95%的问题留给问题留给",rating: 4.5,comments: "好好好",commentId: '2'),
          CartListModel(recordId: 876,orderId: 712,price: "78.12",bookId: 110,name: "老人与海",img:"http://zxts-user-file.oss-cn-beijing.aliyuncs.com/2024-01/20/eb167c2f59f7e34c0ef94a9f1ce736ee64d76a11.jpg",
              introduction: "一想到还有95%的问题留给人类，我就放一想到还有95%的问题留给问题留给",rating: 4.5,comments: "好好好",commentId: '2'),
          CartListModel(recordId: 876,orderId: 712,price: "78.12",bookId: 110,name: "老人与海",img:"http://zxts-user-file.oss-cn-beijing.aliyuncs.com/2024-01/20/eb167c2f59f7e34c0ef94a9f1ce736ee64d76a11.jpg",
              introduction: "一想到还有95%的问题留给人类，我就放一想到还有95%的问题留给问题留给",rating: 4.5,comments: "好好好",commentId: '2'),
          CartListModel(recordId: 876,orderId: 712,price: "78.12",bookId: 110,name: "老人与海",img:"http://zxts-user-file.oss-cn-beijing.aliyuncs.com/2024-01/20/eb167c2f59f7e34c0ef94a9f1ce736ee64d76a11.jpg",
              introduction: "一想到还有95%的问题留给人类，我就放一想到还有95%的问题留给问题留给",rating: 4.5,comments: "好好好",commentId: '2'),]));
    orderList.add(OrderListModel(id:1,ordersnum: "ehfghgfh",totalPrice: "123.2",finalTotalPrice:'80',status: 2,payType: 1,types: 1,createTime: "2024-01-11 11:11:50",
        cartList: [CartListModel(recordId: 876,orderId: 712,price: "78.12",bookId: 110,name: "老人与海",img:"http://zxts-user-file.oss-cn-beijing.aliyuncs.com/2024-01/20/eb167c2f59f7e34c0ef94a9f1ce736ee64d76a11.jpg",
            introduction: "2一想到还有95%的一想到",rating: 4.5,comments: "好好好",commentId: '2'),]));
    orderList.add(OrderListModel(id:1,ordersnum: "234324234dfds",totalPrice: "452.3",finalTotalPrice:'352.3',status: 2,payType: 1,types: 1,createTime: "2024-01-11 11:11:50",
        cartList: [CartListModel(recordId: 876,orderId: 712,price: "78.12",bookId: 110,name: "老人与海",img:"http://zxts-user-file.oss-cn-beijing.aliyuncs.com/2024-01/20/eb167c2f59f7e34c0ef94a9f1ce736ee64d76a11.jpg",
            introduction: "这是一本书",rating: 4.5,comments: "好好好",commentId: '2'),
          CartListModel(recordId: 876,orderId: 712,price: "78.12",bookId: 110,name: "老人与海",img:"http://zxts-user-file.oss-cn-beijing.aliyuncs.com/2024-01/20/eb167c2f59f7e34c0ef94a9f1ce736ee64d76a11.jpg",
              introduction: "这是一本书",rating: 4.5,comments: "好好好",commentId: '2'),
          CartListModel(recordId: 876,orderId: 712,price: "78.12",bookId: 110,name: "老人与海",img:"http://zxts-user-file.oss-cn-beijing.aliyuncs.com/2024-01/20/eb167c2f59f7e34c0ef94a9f1ce736ee64d76a11.jpg",
              introduction: "这是一本书",rating: 4.5,comments: "好好好",commentId: '2'),
          CartListModel(recordId: 876,orderId: 712,price: "78.12",bookId: 110,name: "老人与海",img:"http://zxts-user-file.oss-cn-beijing.aliyuncs.com/2024-01/20/eb167c2f59f7e34c0ef94a9f1ce736ee64d76a11.jpg",
              introduction: "这是一本书",rating: 4.5,comments: "好好好",commentId: '2'),]));
    orderList.add(OrderListModel(id:1,ordersnum: "vbrth54",totalPrice: "25.3",finalTotalPrice:'24',status: 3,payType: 1,types: 1,createTime: "2024-01-11 11:11:50",
        cartList: [CartListModel(recordId: 876,orderId: 712,price: "78.12",bookId: 110,name: "老人与海",img:"http://zxts-user-file.oss-cn-beijing.aliyuncs.com/2024-01/20/eb167c2f59f7e34c0ef94a9f1ce736ee64d76a11.jpg",
            introduction: "3一想到还有95%的想到还有95%的问题留给人类，我就放一想到还有95%的问题留给问题留给",rating: 4.5,comments: "好好好",commentId: '2'),]));
    orderList.add(OrderListModel(id:1,ordersnum: "vbrty65ygfs",totalPrice: "32.5",finalTotalPrice:'31.2',status: 3,payType: 1,types: 1,createTime: "2024-01-11 11:11:50",
        cartList: [CartListModel(recordId: 876,orderId: 712,price: "78.12",bookId: 110,name: "老人与海",img:"http://zxts-user-file.oss-cn-beijing.aliyuncs.com/2024-01/20/eb167c2f59f7e34c0ef94a9f1ce736ee64d76a11.jpg",
            introduction: "这是一本书",rating: 4.5,comments: "好好好",commentId: '2'),
          CartListModel(recordId: 876,orderId: 712,price: "78.12",bookId: 110,name: "老人与海",img:"http://zxts-user-file.oss-cn-beijing.aliyuncs.com/2024-01/20/eb167c2f59f7e34c0ef94a9f1ce736ee64d76a11.jpg",
              introduction: "这是一本书",rating: 4.5,comments: "好好好",commentId: '2'),
          CartListModel(recordId: 876,orderId: 712,price: "78.12",bookId: 110,name: "老人与海",img:"http://zxts-user-file.oss-cn-beijing.aliyuncs.com/2024-01/20/eb167c2f59f7e34c0ef94a9f1ce736ee64d76a11.jpg",
              introduction: "这是一本书",rating: 4.5,comments: "好好好",commentId: '2'),
          CartListModel(recordId: 876,orderId: 712,price: "78.12",bookId: 110,name: "老人与海",img:"http://zxts-user-file.oss-cn-beijing.aliyuncs.com/2024-01/20/eb167c2f59f7e34c0ef94a9f1ce736ee64d76a11.jpg",
              introduction: "这是一本书",rating: 4.5,comments: "好好好",commentId: '2'),]));
    orderList.add(OrderListModel(id:1,ordersnum: "3sdfdfg",totalPrice: "45.8",finalTotalPrice:'42',status: 4,payType: 1,types: 1,createTime: "2024-01-11 11:11:50",
        cartList: [CartListModel(recordId: 876,orderId: 712,price: "78.12",bookId: 110,name: "老人与海",img:"http://zxts-user-file.oss-cn-beijing.aliyuncs.com/2024-01/20/eb167c2f59f7e34c0ef94a9f1ce736ee64d76a11.jpg",
            introduction: "4一想到还有95%的问题到还有95%的问题留给人类，我就放一想到还有95%的问题留给问题留给",rating: 4.5,comments: "好好好",commentId: '2'),]));
    orderList.add(OrderListModel(id:1,ordersnum: "gh45fdg",totalPrice: "99.9",finalTotalPrice:'88.78',status: 4,payType: 1,types: 1,createTime: "2024-01-11 11:11:50",
        cartList: [CartListModel(recordId: 876,orderId: 712,price: "78.12",bookId: 110,name: "老人与海",img:"http://zxts-user-file.oss-cn-beijing.aliyuncs.com/2024-01/20/eb167c2f59f7e34c0ef94a9f1ce736ee64d76a11.jpg",
            introduction: "这是一本书",rating: 4.5,comments: "好好好",commentId: '2'),
          CartListModel(recordId: 876,orderId: 712,price: "78.12",bookId: 110,name: "老人与海",img:"http://zxts-user-file.oss-cn-beijing.aliyuncs.com/2024-01/20/eb167c2f59f7e34c0ef94a9f1ce736ee64d76a11.jpg",
              introduction: "这是一本书",rating: 4.5,comments: "好好好",commentId: '2'),
          CartListModel(recordId: 876,orderId: 712,price: "78.12",bookId: 110,name: "老人与海",img:"http://zxts-user-file.oss-cn-beijing.aliyuncs.com/2024-01/20/eb167c2f59f7e34c0ef94a9f1ce736ee64d76a11.jpg",
              introduction: "这是一本书",rating: 4.5,comments: "好好好",commentId: '2'),
          CartListModel(recordId: 876,orderId: 712,price: "78.12",bookId: 110,name: "老人与海",img:"http://zxts-user-file.oss-cn-beijing.aliyuncs.com/2024-01/20/eb167c2f59f7e34c0ef94a9f1ce736ee64d76a11.jpg",
              introduction: "这是一本书",rating: 4.5,comments: "好好好",commentId: '2'),
          CartListModel(recordId: 876,orderId: 712,price: "78.12",bookId: 110,name: "老人与海",img:"http://zxts-user-file.oss-cn-beijing.aliyuncs.com/2024-01/20/eb167c2f59f7e34c0ef94a9f1ce736ee64d76a11.jpg",
              introduction: "这是一本书",rating: 4.5,comments: "好好好",commentId: '2'),]));
    orderList.add(OrderListModel(ordersnum: "aeewar34r",finalTotalPrice:'80',status: 3,payType: 1,types: 2,createTime: "2024-01-11 11:11:50",));
  }
}
