part of user_point;

class UserPointPage extends StatefulWidget {
  const UserPointPage({Key? key}) : super(key: key);

  @override
  State<UserPointPage> createState() => _UserPointPageState();
}

class _UserPointPageState extends State<UserPointPage> {
  @override
  Widget build(BuildContext context) {
    return WillPopScope(
      onWillPop: () async {
        context.pop(true);
        return false;
      },
      child: GetBuilder<UserPointController>(
        init: UserPointController(),
        builder: (controller) => Scaffold(
          appBar: AppBar(
            title: const Text('积分'),
          ),
          body: CustomPullScrollView(
            controller: controller.refreshController,
            onRefresh: controller.onRefresh,
            onLoading: controller.onLoading,
            child: controller.points.isEmpty?Container(
              padding: EdgeInsets.only(top: 110.w),
              alignment: Alignment.center,
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.center,
                children: [
                  SizedBox(height: 152.w, width: 195.w,
                    child: Image.asset( 'assets/images/none.png',),),
                  SizedBox(height: 13.w,),
                ],
              ),
            ):Container(
              margin: EdgeInsets.all(10.w),
              decoration: BoxDecoration(
                borderRadius: BorderRadius.circular(8.w),
                color: Colors.white,
                boxShadow: [
                  BoxShadow(
                    color: const Color(0xFFC7C7C7).withOpacity(0.5),
                    offset: Offset(3.w, 0),
                    blurRadius: 10.w,
                    spreadRadius: 0.w,
                  ),
                ],
              ),
              child: ListView.builder(
                itemBuilder: (BuildContext context, int index){
                  return BuildCell(model: controller.points[index],);
                },
                itemCount: controller.points.length,
              ),
            ),
          ),
        ),
      ),
    );
  }
}
