part of book_pay;

class BookPayController extends GetxController {
  // 购物车选中的书籍列表
  final List<CourseModel>? buy;
  BookPayController({this.buy});
  // 积分模型
  CreditPointModel creditPointModel = CreditPointModel();
  // 是否展示优惠券和积分模型
  ShowModel showModel = ShowModel();

  // 是否使用积分
  bool useCreditPoint = false;
  // 优惠券可用不可用数量模型
  CouponNumModel couponNumModel = CouponNumModel();
  // 选择的优惠券模型
  late CouponModel useCouponModel =  CouponModel(couponId: 0,reducedPrice: '0.00');

  // 支付方式
  List<PayModel> pays =  Platform.isIOS ?[
    PayModel(type: 3, name: '紫荆币', icon: 'assets/images/pay_coin.png', selected: true),
  ]:[
    PayModel(type: 1, name: '微信', icon: 'assets/images/pay_wechat.png', selected: true),
    PayModel(type: 2, name: '支付宝', icon: 'assets/images/pay_ali.png', selected: false),
    PayModel(type: 3, name: '紫荆币', icon: 'assets/images/pay_coin.png', selected: false),
  ];

  // 时候展示底部视图
  bool showDetail = false;

  // 优惠前的原始价钱
  late double originalPrice = getOriginalPrice();
  late double finalPrice = 0.00;



  @override
  void onReady() {
    _getCreditPoints(price: originalPrice.toString());
    _getShow();
    computeFinalPrice();
    _getCouponNumber();
    super.onReady();
  }

  /// 使用优惠券
  void setUseCoupon(CouponModel model){
    useCouponModel = model;
    print('使用优惠券。。。。。。。。。。。。。。。。');
    computeFinalPrice();
  }

  /// 支付方式 默认第一个
  late PayModel _payModel = pays.first;
  PayModel get payModel => _payModel;

  /// 选择积分状态
  void show(){
    showDetail = !showDetail;
    update();
  }

  /// 设置支付渠道
  void setPayModel(PayModel payModel){
    for (PayModel model in pays) {
      if (model.type == payModel.type){
        model.selected = true;
        _payModel = model;
      }
      else{
        model.selected = false;
      }
    }
    update();
  }

  /// 是否使用积分
  void setUse(){
    useCreditPoint = !useCreditPoint;
    // 计算
    computeFinalPrice();
    update();
  }


  /// 获取积分
  void _getCreditPoints({
    required String price
  }) async {
    creditPointModel = await ShopAPI.creditPoints(price: price);
    update();
  }
  /// 是否展示优惠券 和积分使用 模型
  void _getShow () async {
    showModel = await ShopAPI.show();
    update();
  }

  /// 获取优惠券可用数量与不可用数量模型
  void _getCouponNumber() async{
    couponNumModel = await ShopAPI.couponNum(price: originalPrice.toString());
    update();
  }


  /// 获取优惠前的价钱
  /// 总价钱
  double  getOriginalPrice(){
    Decimal price = Decimal.zero;
    for (CourseModel model in buy!) {
      if (model.status == 1){
        if (model.selected == true){
          price = price + Decimal.parse(model.vipPrice??'0.00');
        }
      }
    }
    return price.toDouble();
  }

  /// 获取优惠后的价格
  void computeFinalPrice(){
    finalPrice = originalPrice;
    if (useCreditPoint){
      finalPrice = finalPrice - Decimal.parse(creditPointModel.deductibleAmount??'0.00').toDouble();
    }
    // 不等0的时候证明使用了 优惠券
    if (useCouponModel.couponId !=0){
      finalPrice = finalPrice - Decimal.parse(useCouponModel.reducedPrice??'0.00').toDouble();
    }
    update();
  }



}