part of study_history;

class BuildDayItem extends StatelessWidget {
  final StudyHistoryModel historyModel;
  final void Function(CourseModel courseModel) onTap;
  const BuildDayItem({
    Key? key,
    required this.historyModel,
    required this.onTap
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: EdgeInsets.only(left: 10.w,top: 10.w,right: 10.w),
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(8.w),
        boxShadow:  [
          BoxShadow(
            color: Colours.cC7.withOpacity(0.5),
            offset:  Offset(1, 3.w),
            blurRadius: 10.w,
            spreadRadius: 0,
          ),
        ],
        color: Colors.white
      ),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          Container(
            margin: EdgeInsets.only(left: 10.w),
            decoration: BoxDecoration(
              borderRadius: BorderRadius.only(
                topLeft: Radius.circular(8.0.w),
                topRight: Radius.circular(8.0.w),
              ),
              // color: Colors.cyan,
            ),
            height: 32.w,
            alignment: Alignment.centerLeft,
            child: Text(historyModel.time??'',style: TextStyle(fontSize: 13.w,height: 1.4,color: Colours.c6),),
          ),
          ListView.builder(
            shrinkWrap: true,
            physics: const NeverScrollableScrollPhysics(),
            itemBuilder:(BuildContext context, int index){
              return GestureDetector(
                onTap: (){
                  onTap(historyModel.courses[index]);
                },
                  child: _buildItem(historyModel.courses[index]));
            },
            itemCount: historyModel.courses.length,
          )
        ],
      ),
    );
  }

  Widget _buildItem(CourseModel courseModel){
    return Container(
      color: Colors.white,
      margin: EdgeInsets.only(left: 10.w,right: 10.w),
      child: Column(
        children: [
          Container(
            color: Colours.cF0,
            height: 0.5.w,
          ),
          Container(
            margin: EdgeInsets.only(top: 11.5.w,bottom: 14.5.w),
            // color: Colors.yellow,
            child: Row(
              crossAxisAlignment: CrossAxisAlignment.start,
              children: [
                CustomCard(
                  width: 72.w,
                  height: 86.w,
                  url: courseModel.img??'',
                ),
                Expanded(
                  child: Container(
                    // color: Colors.green,
                    height: 86.w,
                    padding: EdgeInsets.only(top: 2.5.w,left: 13.w),
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      mainAxisAlignment: MainAxisAlignment.spaceBetween,
                      children: [
                        Column(
                          crossAxisAlignment: CrossAxisAlignment.start,
                          children: [
                            Text(courseModel.bookName??'',style: TextStyle(fontSize: 14.w,height: 1.5,fontWeight: Fonts.medium,color: Colours.c3),maxLines: 1,overflow: TextOverflow.ellipsis,),
                            Gaps.vGaps5,
                            Text(courseModel.authors??'',style: TextStyle(fontSize: 12.w,height: 1.4,color: Colours.c6),),
                          ],
                        ),
                        // Gaps.vGaps25,
                        Row(
                          mainAxisAlignment: MainAxisAlignment.spaceBetween,
                          children: [
                            Container(
                              color: AppTheme.primary.withOpacity(0.1),
                              padding: EdgeInsets.symmetric(horizontal: 3.5.w),
                              child: Text(courseModel.typeName,style: TextStyle(fontSize: 11.w,height: 1.3,color:AppTheme.primary),),
                            ),
                            // Spacer(),
                            Container(
                              width: 120,
                              alignment: Alignment.centerLeft,
                              child: Text('上次读到：${courseModel.lastChapter}',style: TextStyle(fontSize: 11.w,height: 1.3,color: Colours.c6),maxLines: 1,overflow: TextOverflow.ellipsis,),
                            )
                          ],
                        )
                      ],
                    ),
                  ),
                )
              ],
            ),
          )
        ],
      ),
    );
  }
}
