part of book_shop;

class BookshopController extends GetxController {

  final EasyRefreshController refreshController = EasyRefreshController(
    controlFinishLoad: true,
    controlFinishRefresh: true,
  );

  // 书架数组
  List<CourseModel> carts = [];

  final int _limit = 10;
  int _page = 1;
  bool _noMore = false;

  @override
  void onClose() {
    refreshController.dispose();
    super.onClose();
  }

  /// 删除购物车 单个书籍
  void delCart({
    required String cartId,
  }) async {
    bool result = await ShopAPI.delCart(
        cartId: cartId);
    if (result) {
      onRefresh();
    }
  }

  /// 获取课程内图书列表
  Future<void> _getCart([bool isRefresh = false]) async {
    if (isRefresh) _page = 1;
    // 网路请求
    final result = await ShopAPI.cart(
        page: _page,
        limit: _limit
    );
    // 如果是刷新 清理数据
    if (isRefresh) carts.clear();
    carts.addAll(_test());
    carts.addAll(result);
    _page ++;
    _noMore = result.length < _limit;
    update();

  }


  void onRefresh() async {
    try {
      await _getCart(true);
      refreshController.finishRefresh(IndicatorResult.success);
      refreshController.resetFooter();
    } catch (error) {
      refreshController.finishRefresh(IndicatorResult.fail);
    }
  }

  void onLoading() async {
    if (_noMore) {
      refreshController.finishLoad(IndicatorResult.noMore);
      return;
    }
    try {
      await _getCart();
      refreshController.finishLoad();
    } catch (error) {
      refreshController.finishLoad(IndicatorResult.fail);
    }
  }

  List<CourseModel> _test(){
    return [
      CourseModel(),
      CourseModel(),
      CourseModel(),
    ];
  }

}