part of search;

class SearchController extends GetxController {

  late TextEditingController searchController = TextEditingController();

  // 搜索记录数组
  List<String> records = [];
  // 书籍数组
  List<CourseModel> books = [];

  @override
  void onReady() {
    _getSearchRecords();
    super.onReady();
  }

  @override
  void onClose() {
    searchController.dispose();
    super.onClose();
  }

  /// 获取搜索记录
  void _getSearchRecords() async {
    records = await CommonAPI.searchRecords();
    update();
  }

  /// 清除搜索记录
  void clear() async {
    bool result = await CommonAPI.clear();
    if (result) {
      _getSearchRecords();
    }
  }

  /// 搜索书籍
  void search() async {
    books = await CommonAPI.searchBooks(keyWord: searchController.text);
    _getSearchRecords();
    update();
  }


 ///  本地搜索历史
 /*
  ///获取搜索关键字数据
  List<String> _getHistory(){
    List <String>historys = [];
    historys.addAll(StorageService.to.getList(kSearchHistory));
    ///过滤空字符串
    historys.remove('');
    return historys;
  }

  ///存储搜索关键字
  void saveHistory(){
    Tools.unfocus();
    var history = searchController.text;
    ///过滤空字符串
    if(history.isEmpty){
      return;
    }
    List <String>historys = [];
    historys.addAll(StorageService.to.getList(kSearchHistory));
    historys.remove('');


    if(historys.contains(history)){
      historys.remove(history);
      historys.insert(0, history);
    }
    else{
      if (historys.length >= _maxStorageNum){
        historys.remove(historys.last);
        historys.insert(0, history);
      }
      else{
        historys.insert(0, history);
      }
    }
    StorageService.to.setList(kSearchHistory, historys);

    searchList = _getHistory();
    update();
  }

  ///清除搜索关键字
  void clearHistory(){
    StorageService.to.setList(kSearchHistory, []);
    searchList = _getHistory();
    update();
  }

  */




}