part of book_shop;

class BookCell extends StatelessWidget {
  final CourseModel model;
  final void Function() delTap;
  const BookCell({
    super.key,
    required this.model,
    required this.delTap
  });

  @override
  Widget build(BuildContext context) {
    return Container(
      decoration: BoxDecoration(
          borderRadius:BorderRadius.circular(5),
          color: Colors.white,
          boxShadow: [
            BoxShadow(
              color: model.selected?AppTheme.primary.withOpacity(0.21):const Color(0xFFC7C7C7).withOpacity(0.5),
              spreadRadius: 0,
              blurRadius: 10,
              offset: const Offset(3, 0), // changes the position of the shadow
            ),
          ],
          border:model.selected?Border.all(width: 0.5,color: AppTheme.primary):null,
      ),
      margin: const EdgeInsets.only(left: 10,right: 10,top: 10),
      height: 110,
      child: Slidable(
        endActionPane: ActionPane(
          motion: const ScrollMotion(),
          children: [
            SlidableAction(
              // An action can be bigger than the others.
              onPressed: (BuildContext context){
                delTap;
              },
              backgroundColor: AppTheme.primary,
              foregroundColor: Colors.white,
              // icon: Icons.archive,
              label: '删除',
            ),
          ],
        ),
        child: Row(
         children: [
           ///左侧
           Container(
             margin: const EdgeInsets.only(left: 12,right: 11),
             child: Row(
               children: [
                SizedBox(
                   height: 17,
                   width: 17,
                   // color: Colors.cyan,
                   child:  Image.asset(model.selected?'assets/images/pay_check.png':'assets/images/pay_uncheck.png'),
                 ),
                 const SizedBox(width: 12,),
                 Container(
                   decoration: BoxDecoration(
                       color: Colors.cyan,
                     borderRadius: BorderRadius.circular(3),
                       boxShadow: [
                         BoxShadow(
                           color: const Color(0xFF707070).withOpacity(0.5),
                           spreadRadius: 2,
                           blurRadius: 5,
                           offset: const Offset(3, 0), // changes the position of the shadow
                         ),
                       ]
                   ),
                   // color: Colors.white,
                   height: 86,
                   width: 72,
                   child: Container(
                     padding: const EdgeInsets.all(2),
                     child: Container(
                       color: Colors.cyan,
                     ),
                   ),

                 )
               ],
             ),
           ),
           ///右侧
           Expanded(
             child: Container(
               padding: const EdgeInsets.only(top: 12,bottom: 10),
                child: Column(
                  mainAxisAlignment: MainAxisAlignment.spaceBetween,
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      children: [
                        Text(model.bookName??'',style: const TextStyle(fontSize: 13,fontWeight: Fonts.medium,color: Colours.c3),maxLines: 2,overflow: TextOverflow.ellipsis,),
                        const SizedBox(height: 5,),
                        Text(model.authors??'',style: const TextStyle(fontSize: 11,color: Colours.c9)),
                      ],
                    ),
                    Text('￥${model.vipPrice??''}',style: const TextStyle(fontSize: 14,fontWeight: FontWeight.w500,color: AppTheme.primary)),
                  ],
                ),
             ),
           )
         ],
        ),
      )
    );
  }
}
