part of library;

class LibraryContentPage extends StatefulWidget {
  final LibraryController controller;
  // final CategoryModel categoryModel;
  const LibraryContentPage({
    Key? key,
    required this.controller,
    // required this.categoryModel
  }) : super(key: key);

  @override
  State<LibraryContentPage> createState() => _LibraryContentPageState();
}

class _LibraryContentPageState extends State<LibraryContentPage> with AutomaticKeepAliveClientMixin {
  @override
  Widget build(BuildContext context) {
    return CustomPullScrollView(
      controller: widget.controller.refreshController,
      onRefresh: widget.controller.onRefresh,
      onLoading: widget.controller.onLoading,
      child: ListView.builder(
        // shrinkWrap: true,
        // physics: NeverScrollableScrollPhysics(),
        scrollDirection: Axis.vertical,
        itemCount: widget.controller.books.length,
        itemBuilder: (BuildContext context, int index) {
          // if (index == 0){
          //   return Container(
          //     color: Colors.transparent,
          //     padding: const EdgeInsets.symmetric(horizontal: 10),
          //     child: BuildBanner(items: widget.controller.ads,),
          //   );
          // }
          // else {
            CourseModel model = widget.controller.books[index];
            return GestureDetector(
              onTap: (){
                context.pushNamed(Routes.bookDetail,queryParameters: {'book_id':model.bookId.toString()});
              },
              child: LibraryCell(model: model,onTap: (){
                widget.controller.love(bookId: model.bookId.toString(), isCollection: model.isCollection!);
              },),
            );
          }
        // },
      ),
    );
  }
  @override
  bool get wantKeepAlive => true;
}
