part of user_coupon;


class UserCouponPage extends StatefulWidget {
  const UserCouponPage({Key? key}) : super(key: key);

  @override
  State<UserCouponPage> createState() => _UserCouponPageState();
}

class _UserCouponPageState extends State<UserCouponPage> {
  @override
  Widget build(BuildContext context) {
    return GetBuilder<UserCouponController>(
      init: UserCouponController(),
      builder:(controller) => Scaffold(
        appBar: AppBar(
          centerTitle: true,
          title: const Text('优惠券'),
        ),
        body: CustomPullScrollView(
          controller: controller.refreshController,
          onRefresh: controller.onRefresh,
          onLoading: controller.onLoading,
          child: ListView.builder(
              itemBuilder: (BuildContext context, int index){
                if (index == controller.coupons.length){
                  return GestureDetector(
                    onTap: (){
                      controller.getOverCoupons();
                    },
                    child: Container(
                      height: 40,
                      color: Colors.cyan,
                      child: Text('过期优惠券'),
                    ),
                  );
                }
                else {
                  return BuildItem(model: controller.coupons[index],);
                }
              },
              itemCount: controller.coupons.length +1,
          ),
        ),
      ),
    );
  }
}
